/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.geographic;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.AbstractDerivedCRS;
import org.geotools.referencing.crs.AbstractSingleCRS;
import org.opengis.feature.Feature;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.Property;
import org.opengis.feature.type.Name;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.AbstractReader;
import org.openstreetmap.josm.plugins.opendata.core.OdConstants;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ShpReader
extends AbstractReader
implements OdConstants {
    private final AbstractDataSetHandler handler;
    private final CoordinateReferenceSystem wgs84;
    private final Map<String, Node> nodes;
    private DataSet result;
    private CoordinateReferenceSystem crs;
    private MathTransform transform;

    public ShpReader(AbstractDataSetHandler handler) throws NoSuchAuthorityCodeException, FactoryException {
        this.handler = handler;
        this.wgs84 = CRS.decode("EPSG:4326");
        this.nodes = new HashMap<String, Node>();
    }

    public static DataSet parseDataSet(InputStream in, File file, AbstractDataSetHandler handler, ProgressMonitor instance) throws IOException {
        if (in != null) {
            in.close();
        }
        try {
            return new ShpReader(handler).parse(file, instance);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }

    private static final void compareDebug(CoordinateReferenceSystem crs1, CoordinateReferenceSystem crs2) {
        Integer dim2;
        Integer dim1;
        System.out.println("-- COMPARING " + crs1.getName() + " WITH " + crs2.getName() + " --");
        ShpReader.compareDebug("class", crs1.getClass(), crs2.getClass());
        CoordinateSystem cs1 = crs1.getCoordinateSystem();
        CoordinateSystem cs2 = crs2.getCoordinateSystem();
        if (!ShpReader.compareDebug("cs", cs1, cs2) && ShpReader.compareDebug("cs.dim", dim1 = Integer.valueOf(cs1.getDimension()), dim2 = Integer.valueOf(cs2.getDimension()))) {
            for (int i = 0; i < dim1; ++i) {
                ShpReader.compareDebug("cs.axis" + i, cs1.getAxis(i), cs1.getAxis(i));
            }
        }
        if (crs1 instanceof AbstractSingleCRS) {
            Datum datum2;
            Datum datum1 = ((AbstractSingleCRS)crs1).getDatum();
            if (!ShpReader.compareDebug("datum", datum1, datum2 = ((AbstractSingleCRS)crs2).getDatum())) {
                AbstractIdentifiedObject adatum1 = (AbstractIdentifiedObject)((Object)datum1);
                AbstractIdentifiedObject adatum2 = (AbstractIdentifiedObject)((Object)datum2);
                ShpReader.compareDebug("datum.name1", adatum1.nameMatches(adatum2.getName().getCode()), adatum1.getName(), adatum2.getName());
                ShpReader.compareDebug("datum.name2", adatum2.nameMatches(adatum1.getName().getCode()), adatum2.getName(), adatum1.getName());
            }
            if (crs1 instanceof AbstractDerivedCRS) {
                AbstractDerivedCRS adcrs1 = (AbstractDerivedCRS)crs1;
                AbstractDerivedCRS adcrs2 = (AbstractDerivedCRS)crs2;
                ShpReader.compareDebug("baseCRS", adcrs1.getBaseCRS(), adcrs2.getBaseCRS());
                ShpReader.compareDebug("conversionFromBase", adcrs1.getConversionFromBase(), adcrs2.getConversionFromBase());
            }
        }
        System.out.println("-- COMPARING FINISHED --");
    }

    private static final boolean compareDebug(String text, Object o1, Object o2) {
        return ShpReader.compareDebug(text, o1.equals(o2), o1, o2);
    }

    private static final boolean compareDebug(String text, IdentifiedObject o1, IdentifiedObject o2) {
        return ShpReader.compareDebug(text, (AbstractIdentifiedObject)o1, (AbstractIdentifiedObject)o2);
    }

    private static final boolean compareDebug(String text, AbstractIdentifiedObject o1, AbstractIdentifiedObject o2) {
        return ShpReader.compareDebug(text, o1.equals(o2, false), o1, o2);
    }

    private static final boolean compareDebug(String text, boolean result, Object o1, Object o2) {
        System.out.println(text + ": " + result + "(" + o1 + ", " + o2 + ")");
        return result;
    }

    /*
     * Exception decompiling
     */
    public DataSet parse(File file, ProgressMonitor instance) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK]], but top level block is 30[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static final boolean warnLenientMethod(Component parent, CoordinateReferenceSystem crs) {
        ExtendedDialog dlg = new ExtendedDialog(parent, I18n.tr((String)"Cannot transform to WGS84", (Object[])new Object[0]), new String[]{I18n.tr((String)"Cancel", (Object[])new Object[0]), I18n.tr((String)"Continue", (Object[])new Object[0])});
        dlg.setContent("<html>" + I18n.tr((String)"JOSM was unable to find a strict mathematical transformation between ''{0}'' and WGS84.<br /><br />Do you want to try a <i>lenient</i> method, which will perform a non-precise transformation (<b>with location errors up to 1 km</b>) ?<br/><br/>If so, <b>do NOT upload</b> such data to OSM !", (Object[])new Object[]{crs.getName()}) + "</html>");
        dlg.setButtonIcons(new Icon[]{ImageProvider.get((String)"cancel"), ImageProvider.overlay((Icon)ImageProvider.get((String)"ok"), (Icon)new ImageIcon(ImageProvider.get((String)"warning-small").getImage().getScaledInstance(10, 10, 4)), (ImageProvider.OverlayPosition)ImageProvider.OverlayPosition.SOUTHEAST)});
        dlg.setToolTipTexts(new String[]{I18n.tr((String)"Cancel", (Object[])new Object[0]), I18n.tr((String)"Try lenient method", (Object[])new Object[0])});
        dlg.setIcon(2);
        dlg.setCancelButton(new Integer[]{1});
        return dlg.showDialog().getValue() != 2;
    }

    private static final void readNonGeometricAttributes(Feature feature, OsmPrimitive primitive) {
        for (Property prop : feature.getProperties()) {
            if (prop instanceof GeometryAttribute) continue;
            Name name = prop.getName();
            Object value = prop.getValue();
            if (name == null || value == null) continue;
            String sName = ((Object)name).toString();
            String sValue = value.toString();
            if (sName.isEmpty() || sValue.isEmpty()) continue;
            primitive.put(sName, sValue);
        }
    }

    private Node createOrGetNode(Point p) throws MismatchedDimensionException, TransformException {
        if (this.transform != null) {
            Point p2 = (Point)JTS.transform(p, this.transform);
            String key = p2.getX() + "/" + p2.getY();
            Node n = this.nodes.get(key);
            if (n == null) {
                n = new Node(new LatLon(p2.getY(), p2.getX()));
                this.nodes.put(key, n);
                this.result.addPrimitive((OsmPrimitive)n);
            }
            return n;
        }
        EastNorth en = new EastNorth(p.getX(), p.getY());
        return new Node(en);
    }

    private Way createWay(LineString ls) {
        Way w = new Way();
        if (ls != null) {
            for (int i = 0; i < ls.getNumPoints(); ++i) {
                try {
                    w.addNode(this.createOrGetNode(ls.getPointN(i)));
                    continue;
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
        }
        this.result.addPrimitive((OsmPrimitive)w);
        return w;
    }

    private Relation createMultipolygon() {
        Relation r = new Relation();
        r.put("type", "multipolygon");
        this.result.addPrimitive((OsmPrimitive)r);
        return r;
    }

    private void addWayToMp(Relation r, String role, Way w) {
        r.addMember(new RelationMember(role, (OsmPrimitive)w));
    }
}

