/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.actions;

import java.awt.event.ActionEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.plugins.opendata.core.OdConstants;
import org.openstreetmap.josm.tools.OpenBrowser;

public class OpenLinkAction
extends JosmAction
implements OdConstants {
    private URL url;

    public OpenLinkAction(URL url, String icon24Name, String title, String description) {
        super(title, icon24Name, description, null, false);
        this.url = url;
    }

    public void actionPerformed(ActionEvent e) {
        try {
            System.out.println("Opening " + this.url);
            OpenBrowser.displayUrl((URI)this.url.toURI());
        }
        catch (URISyntaxException e1) {
            try {
                System.err.println(e1.getLocalizedMessage());
                int index = e1.getIndex();
                if (index > -1) {
                    String s = this.url.toString().substring(index, index + 1);
                    s = this.url.toString().replace(s, URLEncoder.encode(s, "UTF-8"));
                    URI uri = new URI(s);
                    System.out.println("Opening " + uri);
                    OpenBrowser.displayUrl((URI)uri);
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }
}

