/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import org.geotools.factory.Hints;

public final class Utilities {
    private static final String[] spaces = new String[21];
    private static final Queue<?> EMPTY_QUEUE;

    private Utilities() {
    }

    public static boolean equals(double o1, double o2) {
        if (Double.doubleToLongBits(o1) == Double.doubleToLongBits(o2)) {
            return true;
        }
        double tol = Utilities.getTolerance();
        double min = o1 - Math.signum(o1) * o1 * tol;
        double max = o1 + Math.signum(o1) * o1 * tol;
        return min <= o2 && o2 <= max;
    }

    private static double getTolerance() {
        Double tol = (Double)Hints.getSystemDefault(Hints.COMPARISON_TOLERANCE);
        if (tol == null) {
            return Hints.COMPARISON_TOLERANCE.getDefault();
        }
        return tol;
    }

    public static boolean equals(Object object1, Object object2) throws AssertionError {
        assert (object1 == null || !object1.getClass().isArray()) : object1;
        assert (object2 == null || !object2.getClass().isArray()) : object2;
        return object1 == object2 || object1 != null && object1.equals(object2);
    }

    public static boolean deepEquals(Object object1, Object object2) {
        if (object1 == object2) {
            return true;
        }
        if (object1 == null || object2 == null) {
            return false;
        }
        if (object1 instanceof Object[]) {
            return object2 instanceof Object[] && Arrays.deepEquals((Object[])object1, (Object[])object2);
        }
        if (object1 instanceof double[]) {
            return object2 instanceof double[] && Arrays.equals((double[])object1, (double[])object2);
        }
        if (object1 instanceof float[]) {
            return object2 instanceof float[] && Arrays.equals((float[])object1, (float[])object2);
        }
        if (object1 instanceof long[]) {
            return object2 instanceof long[] && Arrays.equals((long[])object1, (long[])object2);
        }
        if (object1 instanceof int[]) {
            return object2 instanceof int[] && Arrays.equals((int[])object1, (int[])object2);
        }
        if (object1 instanceof short[]) {
            return object2 instanceof short[] && Arrays.equals((short[])object1, (short[])object2);
        }
        if (object1 instanceof byte[]) {
            return object2 instanceof byte[] && Arrays.equals((byte[])object1, (byte[])object2);
        }
        if (object1 instanceof char[]) {
            return object2 instanceof char[] && Arrays.equals((char[])object1, (char[])object2);
        }
        if (object1 instanceof boolean[]) {
            return object2 instanceof boolean[] && Arrays.equals((boolean[])object1, (boolean[])object2);
        }
        return object1.equals(object2);
    }

    public static String spaces(int length) {
        String s;
        if (length < 0) {
            length = 0;
        }
        if (length < spaces.length) {
            s = spaces[length];
            if (s == null) {
                Utilities.spaces[length] = s = spaces[spaces.length - 1].substring(0, length).intern();
            }
        } else {
            char[] blancs = new char[length];
            Arrays.fill(blancs, ' ');
            s = new String(blancs);
        }
        return s;
    }

    static {
        int last = spaces.length - 1;
        char[] blancs = new char[last];
        Arrays.fill(blancs, ' ');
        Utilities.spaces[last] = new String(blancs).intern();
        EMPTY_QUEUE = new EmptyQueue();
    }

    private static final class EmptyQueue<E>
    extends AbstractQueue<E>
    implements Serializable {
        private static final long serialVersionUID = -6147951199761870325L;

        private EmptyQueue() {
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator<E> iterator() {
            Set empty = Collections.emptySet();
            return empty.iterator();
        }

        @Override
        public boolean offer(E e) {
            return false;
        }

        @Override
        public E poll() {
            return null;
        }

        @Override
        public E peek() {
            return null;
        }

        protected Object readResolve() {
            return EMPTY_QUEUE;
        }
    }
}

