/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources.geometry;

import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;

public final class ShapeUtilities {
    private static final double EPS = 1.0E-6;
    public static final int PARALLEL = 0;
    public static final int HORIZONTAL = 1;

    private ShapeUtilities() {
    }

    public static Point2D parabolicControlPoint(double x0, double y0, double x1, double y1, double x2, double y2, int orientation, Point2D dest) throws IllegalArgumentException {
        x1 -= x0;
        y1 -= y0;
        x2 -= x0;
        y2 -= y0;
        switch (orientation) {
            case 0: {
                double rx2 = x2;
                double ry2 = y2;
                x2 = Math.hypot(x2, y2);
                y2 = (x1 * rx2 + y1 * ry2) / x2;
                y1 = (y1 * rx2 - x1 * ry2) / x2;
                x1 = y2;
                y2 = 0.0;
                double x = 0.5;
                double y = y1 * 0.5 * x2 / (x1 * (x2 - x1));
                double check = Math.abs(y);
                if (!(check <= 1000000.0)) {
                    return null;
                }
                if (!(check >= 1.0E-6)) {
                    return null;
                }
                x1 = 0.5 * rx2 - y * ry2 + x0;
                y1 = y * rx2 + 0.5 * ry2 + y0;
                break;
            }
            case 1: {
                double a = (y2 - y1 * x2 / x1) / (x2 - x1);
                double check = Math.abs(a);
                if (!(check <= 1000000.0)) {
                    return null;
                }
                if (!(check >= 1.0E-6)) {
                    return null;
                }
                double b = y2 / x2 - a;
                x1 = (1.0 + b / (2.0 * a)) * x2 - y2 / (2.0 * a);
                y1 = y0 + b * x1;
                x1 += x0;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (dest != null) {
            dest.setLocation(x1, y1);
            return dest;
        }
        return new Point2D.Double(x1, y1);
    }

    public static Shape toPrimitive(Shape path) {
        float[] buffer = new float[6];
        PathIterator it = path.getPathIterator(null);
        if (!it.isDone() && it.currentSegment(buffer) == 0 && !it.isDone()) {
            float x1 = buffer[0];
            float y1 = buffer[1];
            int code = it.currentSegment(buffer);
            if (it.isDone()) {
                switch (code) {
                    case 1: {
                        return new Line2D.Float(x1, y1, buffer[0], buffer[1]);
                    }
                    case 2: {
                        return new QuadCurve2D.Float(x1, y1, buffer[0], buffer[1], buffer[2], buffer[3]);
                    }
                    case 3: {
                        return new CubicCurve2D.Float(x1, y1, buffer[0], buffer[1], buffer[2], buffer[3], buffer[4], buffer[5]);
                    }
                }
            }
        }
        return path;
    }
}

