/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.lang.reflect.Array;

public final class XArray {
    private XArray() {
    }

    private static <T> T doResize(T array, int length) {
        int current;
        int n = current = array == null ? 0 : Array.getLength(array);
        if (current != length) {
            Object newArray = Array.newInstance(array.getClass().getComponentType(), length);
            System.arraycopy(array, 0, newArray, 0, Math.min(current, length));
            return (T)newArray;
        }
        return array;
    }

    public static <E> E[] resize(E[] array, int length) {
        return XArray.doResize(array, length);
    }

    public static int[] resize(int[] array, int length) {
        return XArray.doResize(array, length);
    }

    private static <T> T doRemove(T array, int index, int length) {
        if (length == 0) {
            return array;
        }
        int arrayLength = Array.getLength(array);
        Object newArray = Array.newInstance(array.getClass().getComponentType(), arrayLength -= length);
        System.arraycopy(array, 0, newArray, 0, index);
        System.arraycopy(array, index + length, newArray, index, arrayLength - index);
        return (T)newArray;
    }

    public static <E> E[] remove(E[] array, int index, int length) {
        return XArray.doRemove(array, index, length);
    }

    private static <T> T doInsert(T array, int index, int length) {
        if (length == 0) {
            return array;
        }
        int arrayLength = Array.getLength(array);
        Object newArray = Array.newInstance(array.getClass().getComponentType(), arrayLength + length);
        System.arraycopy(array, 0, newArray, 0, index);
        System.arraycopy(array, index, newArray, index + length, arrayLength - index);
        return (T)newArray;
    }

    public static <E> E[] insert(E[] array, int index, int length) {
        return XArray.doInsert(array, index, length);
    }
}

