/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.util.Date;
import org.geotools.resources.XArray;

public abstract class ClassChanger<S extends Comparable<S>, T extends Number> {
    private static ClassChanger<?, ?>[] changers = new ClassChanger[]{new ClassChanger<Date, Long>(Date.class, Long.class){

        @Override
        protected Long convert(Date object) {
            return object.getTime();
        }

        @Override
        protected Date inverseConvert(Long value) {
            return new Date(value);
        }
    }};
    private final Class<S> source;
    private final Class<T> target;

    protected ClassChanger(Class<S> source, Class<T> target) {
        this.source = source;
        this.target = target;
        if (!Comparable.class.isAssignableFrom(source)) {
            throw new IllegalArgumentException(String.valueOf(source));
        }
        if (!Number.class.isAssignableFrom(target)) {
            throw new IllegalArgumentException(String.valueOf(target));
        }
    }

    protected abstract T convert(S var1) throws ClassCastException;

    protected abstract S inverseConvert(T var1);

    public String toString() {
        return "ClassChanger[" + this.source.getName() + "\u00a0\u21e8\u00a0" + this.target.getName() + ']';
    }

    public static synchronized void register(ClassChanger<?, ?> converter) throws IllegalStateException {
        int i;
        for (i = 0; i < changers.length; ++i) {
            if (!ClassChanger.changers[i].source.isAssignableFrom(converter.source)) continue;
            for (int j = i; j < changers.length; ++j) {
                if (!ClassChanger.changers[j].source.equals(converter.source)) continue;
                throw new IllegalStateException(changers[j].toString());
            }
            break;
        }
        changers = XArray.insert(changers, i, 1);
        ClassChanger.changers[i] = converter;
    }
}

