/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.cs;

import java.util.Map;
import javax.measure.quantity.Quantity;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotools.referencing.cs.AbstractCS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;

public class DefaultEllipsoidalCS
extends AbstractCS
implements EllipsoidalCS {
    private static final long serialVersionUID = -1452492488902329211L;
    public static DefaultEllipsoidalCS GEODETIC_2D = new DefaultEllipsoidalCS(DefaultEllipsoidalCS.name(83), DefaultCoordinateSystemAxis.GEODETIC_LONGITUDE, DefaultCoordinateSystemAxis.GEODETIC_LATITUDE);
    public static DefaultEllipsoidalCS GEODETIC_3D = new DefaultEllipsoidalCS(DefaultEllipsoidalCS.name(84), DefaultCoordinateSystemAxis.GEODETIC_LONGITUDE, DefaultCoordinateSystemAxis.GEODETIC_LATITUDE, DefaultCoordinateSystemAxis.ELLIPSOIDAL_HEIGHT);

    public DefaultEllipsoidalCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1) {
        super(properties, new CoordinateSystemAxis[]{axis0, axis1});
    }

    public DefaultEllipsoidalCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1, CoordinateSystemAxis axis2) {
        super(properties, new CoordinateSystemAxis[]{axis0, axis1, axis2});
    }

    private DefaultEllipsoidalCS(Map<String, ?> properties, CoordinateSystemAxis[] axis) {
        super(properties, axis);
    }

    @Override
    protected boolean isCompatibleDirection(AxisDirection direction) {
        return AxisDirection.NORTH.equals(direction = direction.absolute()) || AxisDirection.EAST.equals(direction) || AxisDirection.UP.equals(direction);
    }

    @Override
    protected boolean isCompatibleUnit(AxisDirection direction, Unit<?> unit) {
        Unit<Quantity> expected = AxisDirection.UP.equals(direction = direction.absolute()) ? SI.METER : NonSI.DEGREE_ANGLE;
        return expected.isCompatible(unit);
    }
}

