/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.measure;

import java.io.Serializable;
import org.geotools.resources.ClassChanger;

public class Angle
implements Comparable<Angle>,
Serializable {
    private static final long serialVersionUID = 1158747349433104534L;
    private final double theta;

    public Angle(double theta) {
        this.theta = theta;
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.theta);
        return (int)code ^ (int)(code >>> 32);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && this.getClass().equals(object.getClass())) {
            Angle that = (Angle)object;
            return Double.doubleToLongBits(this.theta) == Double.doubleToLongBits(that.theta);
        }
        return false;
    }

    @Override
    public int compareTo(Angle that) {
        return Double.compare(this.theta, that.theta);
    }

    static {
        ClassChanger.register(new ClassChanger<Angle, Double>(Angle.class, Double.class){

            @Override
            protected Double convert(Angle o) {
                return o.theta;
            }

            @Override
            protected Angle inverseConvert(Double value) {
                return new Angle(value);
            }
        });
    }
}

