/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.nio.ByteBuffer;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;

public class PointHandler
implements ShapeHandler {
    final ShapeType shapeType;
    GeometryFactory geometryFactory;

    public PointHandler(ShapeType type, GeometryFactory gf) throws ShapefileException {
        if (type != ShapeType.POINT && type != ShapeType.POINTM && type != ShapeType.POINTZ) {
            throw new ShapefileException("PointHandler constructor: expected a type of 1, 11 or 21");
        }
        this.shapeType = type;
        this.geometryFactory = gf;
    }

    public PointHandler() {
        this.shapeType = ShapeType.POINT;
    }

    @Override
    public Object read(ByteBuffer buffer, ShapeType type, boolean flatGeometry) {
        if (type == ShapeType.NULL) {
            return this.createNull();
        }
        int dimension = this.shapeType == ShapeType.POINTZ && !flatGeometry ? 3 : 2;
        CoordinateSequence cs = this.geometryFactory.getCoordinateSequenceFactory().create(1, dimension);
        cs.setOrdinate(0, 0, buffer.getDouble());
        cs.setOrdinate(0, 1, buffer.getDouble());
        if (this.shapeType == ShapeType.POINTM) {
            buffer.getDouble();
        }
        if (dimension > 2) {
            cs.setOrdinate(0, 2, buffer.getDouble());
        }
        return this.geometryFactory.createPoint(cs);
    }

    private Object createNull() {
        return this.geometryFactory.createPoint(new Coordinate(Double.NaN, Double.NaN, Double.NaN));
    }
}

