/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import java.io.File;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import org.geotools.data.DataUtilities;
import org.geotools.data.shapefile.FileChannelDecorator;
import org.geotools.data.shapefile.FileReader;
import org.geotools.data.shapefile.FileWriter;
import org.geotools.data.shapefile.MemoryMapCache;
import org.geotools.data.shapefile.ReadableByteChannelDecorator;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.shapefile.ShpFileType;
import org.geotools.data.shapefile.ShpFilesLocker;

public class ShpFiles {
    protected final Map<ShpFileType, URL> urls = new ConcurrentHashMap<ShpFileType, URL>();
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Map<Thread, Collection<ShpFilesLocker>> lockers = new ConcurrentHashMap<Thread, Collection<ShpFilesLocker>>();
    private final MemoryMapCache mapCache = new MemoryMapCache();
    private boolean memoryMapCacheEnabled;

    public ShpFiles(URL url) throws IllegalArgumentException {
        this.init(url);
    }

    private void init(URL url) {
        String base = this.baseName(url);
        if (base == null) {
            throw new IllegalArgumentException(url.getPath() + " is not one of the files types that is known to be associated with a shapefile");
        }
        String urlString = url.toExternalForm();
        char lastChar = urlString.charAt(urlString.length() - 1);
        boolean upperCase = Character.isUpperCase(lastChar);
        for (ShpFileType type : ShpFileType.values()) {
            URL newURL;
            String extensionWithPeriod = type.extensionWithPeriod;
            extensionWithPeriod = upperCase ? extensionWithPeriod.toUpperCase() : extensionWithPeriod.toLowerCase();
            String string = base + extensionWithPeriod;
            try {
                newURL = new URL(url, string);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            this.urls.put(type, newURL);
        }
        if (this.isLocal()) {
            Set<Map.Entry<ShpFileType, URL>> entries = this.urls.entrySet();
            HashMap<ShpFileType, URL> toUpdate = new HashMap<ShpFileType, URL>();
            for (Map.Entry<ShpFileType, URL> entry : entries) {
                if (this.exists(entry.getKey()) || (url = this.findExistingFile(entry.getKey(), entry.getValue())) == null) continue;
                toUpdate.put(entry.getKey(), url);
            }
            this.urls.putAll(toUpdate);
        }
    }

    private URL findExistingFile(ShpFileType shpFileType, URL value) {
        final File file = DataUtilities.urlToFile(value);
        File directory = file.getParentFile();
        if (directory == null || !directory.exists()) {
            return null;
        }
        File[] files = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return file.getName().equalsIgnoreCase(name);
            }
        });
        if (files.length > 0) {
            try {
                return files[0].toURI().toURL();
            }
            catch (MalformedURLException e) {
                ShapefileDataStoreFactory.LOGGER.log(Level.SEVERE, "", e);
            }
        }
        return null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    public void dispose() {
        if (this.numberOfLocks() != 0) {
            this.logCurrentLockers(Level.SEVERE);
            this.lockers.clear();
        }
        this.mapCache.clean();
    }

    public void logCurrentLockers(Level logLevel) {
        for (Collection<ShpFilesLocker> lockerList : this.lockers.values()) {
            for (ShpFilesLocker locker : lockerList) {
                StringBuilder sb = new StringBuilder("The following locker still has a lock: ");
                sb.append(locker);
                ShapefileDataStoreFactory.LOGGER.log(logLevel, sb.toString());
            }
        }
    }

    protected String baseName(Object obj) {
        for (ShpFileType type : ShpFileType.values()) {
            Serializable file;
            String base = null;
            if (obj instanceof File) {
                file = (File)obj;
                base = type.toBase((File)file);
            }
            if (obj instanceof URL) {
                file = (URL)obj;
                base = type.toBase((URL)file);
            }
            if (base == null) continue;
            return base;
        }
        return null;
    }

    public String get(ShpFileType type) {
        return this.urls.get((Object)type).toExternalForm();
    }

    public int numberOfLocks() {
        int count = 0;
        for (Collection<ShpFilesLocker> lockerList : this.lockers.values()) {
            count += lockerList.size();
        }
        return count;
    }

    public URL acquireRead(ShpFileType type, FileReader requestor) {
        URL url = this.urls.get((Object)type);
        if (url == null) {
            return null;
        }
        this.readWriteLock.readLock().lock();
        Collection<ShpFilesLocker> threadLockers = this.getCurrentThreadLockers();
        threadLockers.add(new ShpFilesLocker(url, requestor));
        return url;
    }

    public void unlockRead(URL url, FileReader requestor) {
        if (url == null) {
            throw new NullPointerException("url cannot be null");
        }
        if (requestor == null) {
            throw new NullPointerException("requestor cannot be null");
        }
        Collection<ShpFilesLocker> threadLockers = this.getCurrentThreadLockers();
        boolean removed = threadLockers.remove(new ShpFilesLocker(url, requestor));
        if (!removed) {
            throw new IllegalArgumentException("Expected requestor " + requestor + " to have locked the url but it does not hold the lock for the URL");
        }
        if (threadLockers.size() == 0) {
            this.lockers.remove(Thread.currentThread());
        }
        this.readWriteLock.readLock().unlock();
    }

    public void unlockWrite(URL url, FileWriter requestor) {
        if (url == null) {
            throw new NullPointerException("url cannot be null");
        }
        if (requestor == null) {
            throw new NullPointerException("requestor cannot be null");
        }
        Collection<ShpFilesLocker> threadLockers = this.getCurrentThreadLockers();
        boolean removed = threadLockers.remove(new ShpFilesLocker(url, requestor));
        if (!removed) {
            throw new IllegalArgumentException("Expected requestor " + requestor + " to have locked the url but it does not hold the lock for the URL");
        }
        if (threadLockers.size() == 0) {
            this.lockers.remove(Thread.currentThread());
        } else {
            this.regainReadLocks(threadLockers);
        }
        this.readWriteLock.writeLock().unlock();
    }

    private Collection<ShpFilesLocker> getCurrentThreadLockers() {
        Collection<ShpFilesLocker> threadLockers = this.lockers.get(Thread.currentThread());
        if (threadLockers == null) {
            threadLockers = new ArrayList<ShpFilesLocker>();
            this.lockers.put(Thread.currentThread(), threadLockers);
        }
        return threadLockers;
    }

    private void regainReadLocks(Collection<ShpFilesLocker> threadLockers) {
        for (ShpFilesLocker shpFilesLocker : threadLockers) {
            if (shpFilesLocker.reader == null || !shpFilesLocker.upgraded) continue;
            this.readWriteLock.readLock().lock();
            shpFilesLocker.upgraded = false;
        }
    }

    public boolean isLocal() {
        return this.urls.get((Object)ShpFileType.SHP).toExternalForm().toLowerCase().startsWith("file:");
    }

    public InputStream getInputStream(ShpFileType type, final FileReader requestor) throws IOException {
        final URL url = this.acquireRead(type, requestor);
        try {
            FilterInputStream input = new FilterInputStream(url.openStream()){
                private volatile boolean closed;
                {
                    super(x0);
                    this.closed = false;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        if (!this.closed) {
                            this.closed = true;
                            ShpFiles.this.unlockRead(url, requestor);
                        }
                    }
                }
            };
            return input;
        }
        catch (Throwable e) {
            this.unlockRead(url, requestor);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new RuntimeException(e);
        }
    }

    public ReadableByteChannel getReadChannel(ShpFileType type, FileReader requestor) throws IOException {
        URL url = this.acquireRead(type, requestor);
        ReadableByteChannel channel = null;
        try {
            if (this.isLocal()) {
                File file = DataUtilities.urlToFile(url);
                RandomAccessFile raf = new RandomAccessFile(file, "r");
                channel = new FileChannelDecorator(raf.getChannel(), this, url, requestor);
            } else {
                InputStream in = url.openConnection().getInputStream();
                channel = new ReadableByteChannelDecorator(Channels.newChannel(in), this, url, requestor);
            }
        }
        catch (Throwable e) {
            this.unlockRead(url, requestor);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new RuntimeException(e);
        }
        return channel;
    }

    public String getTypeName() {
        int slash;
        String path = ShpFileType.SHP.toBase(this.urls.get((Object)ShpFileType.SHP));
        int dot = path.indexOf(46, slash = Math.max(0, path.lastIndexOf(47) + 1));
        if (dot < 0) {
            dot = path.length();
        }
        return path.substring(slash, dot);
    }

    MappedByteBuffer map(FileChannel wrapped, URL url, FileChannel.MapMode mode, long position, long size) throws IOException {
        if (this.memoryMapCacheEnabled) {
            return this.mapCache.map(wrapped, url, mode, position, size);
        }
        return wrapped.map(mode, position, size);
    }

    public void setMemoryMapCacheEnabled(boolean memoryMapCacheEnabled) {
        this.memoryMapCacheEnabled = memoryMapCacheEnabled;
        if (!memoryMapCacheEnabled) {
            this.mapCache.clean();
        }
    }

    public boolean exists(ShpFileType fileType) throws IllegalArgumentException {
        if (!this.isLocal()) {
            throw new IllegalArgumentException("This method only makes sense if the files are local");
        }
        URL url = this.urls.get((Object)fileType);
        if (url == null) {
            return false;
        }
        File file = DataUtilities.urlToFile(url);
        return file.exists();
    }
}

