/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Level;
import org.geotools.data.AbstractFileDataStore;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.FIDFeatureReader;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.ServiceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.FileReader;
import org.geotools.data.shapefile.ShapefileAttributeReader;
import org.geotools.data.shapefile.ShapefileFeatureLocking;
import org.geotools.data.shapefile.ShapefileFeatureSource;
import org.geotools.data.shapefile.ShapefileFeatureStore;
import org.geotools.data.shapefile.ShapefileFileServiceInfo;
import org.geotools.data.shapefile.ShapefileURLServiceInfo;
import org.geotools.data.shapefile.ShpFileType;
import org.geotools.data.shapefile.ShpFiles;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.indexed.ShapeFIDReader;
import org.geotools.data.shapefile.prj.PrjFileReader;
import org.geotools.data.shapefile.shp.IndexFile;
import org.geotools.data.shapefile.shp.JTSUtilities;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.data.shapefile.shp.ShapefileHeader;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.data.shapefile.shp.xml.Metadata;
import org.geotools.data.shapefile.shp.xml.ShpXmlFileReader;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.Hints;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.BasicFeatureTypes;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.visitor.ExtractBoundsFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.resources.Classes;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.filter.Filter;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ShapefileDataStore
extends AbstractFileDataStore {
    public static final String ORIGINAL_FIELD_NAME = "original";
    public static final String ORIGINAL_FIELD_DUPLICITY_COUNT = "count";
    protected static final Boolean TRACE_ENABLED = "true".equalsIgnoreCase(System.getProperty("gt2.shapefile.trace"));
    protected ShpFiles shpFiles;
    protected URI namespace = null;
    protected SimpleFeatureType schema;
    protected boolean useMemoryMappedBuffer = false;
    protected Charset dbfCharset;
    protected TimeZone dbfTimeZone = TimeZone.getDefault();
    private ServiceInfo info;
    Exception trace;

    public ShapefileDataStore(URL url, URI namespace, boolean useMemoryMapped, boolean cacheMemoryMap, Charset dbfCharset) {
        this.namespace = namespace;
        this.shpFiles = new ShpFiles(url);
        this.useMemoryMappedBuffer = !this.isLocal() || !this.shpFiles.exists(ShpFileType.SHP) ? false : useMemoryMapped;
        this.shpFiles.setMemoryMapCacheEnabled(this.useMemoryMappedBuffer && cacheMemoryMap);
        this.dbfCharset = dbfCharset;
        if (TRACE_ENABLED.booleanValue()) {
            this.trace = new Exception();
            this.trace.fillInStackTrace();
        }
    }

    @Override
    public synchronized ServiceInfo getInfo() {
        if (this.info == null) {
            this.info = this.isLocal() ? new ShapefileFileServiceInfo(this) : new ShapefileURLServiceInfo(this);
        }
        return this.info;
    }

    public void setDbftimeZone(TimeZone dbftimeZone) {
        this.dbfTimeZone = dbftimeZone;
    }

    @Override
    protected Map createMetadata(String typeName) {
        String urlString = this.shpFiles.get(ShpFileType.SHP_XML);
        if (urlString == null) {
            return Collections.EMPTY_MAP;
        }
        try {
            ShpXmlFileReader reader = new ShpXmlFileReader(this.shpFiles);
            HashMap<String, Metadata> map = new HashMap<String, Metadata>();
            map.put("shp.xml", reader.parse());
            return map;
        }
        catch (Throwable t) {
            LOGGER.warning("Could not parse " + urlString + ":" + t.getLocalizedMessage());
            return Collections.EMPTY_MAP;
        }
    }

    public boolean isLocal() {
        return this.shpFiles.isLocal();
    }

    @Override
    protected FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(String typeName) throws IOException {
        this.typeCheck(typeName);
        return this.getFeatureReader();
    }

    @Override
    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader() throws IOException {
        try {
            return this.createFeatureReader(this.getSchema().getTypeName(), this.getAttributesReader(true, null), this.schema);
        }
        catch (SchemaException se) {
            throw new DataSourceException("Error creating schema", se);
        }
    }

    @Override
    protected FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(String typeName, Query query) throws IOException {
        String[] propertyNames = query.getPropertyNames();
        String defaultGeomName = this.schema.getGeometryDescriptor().getLocalName();
        FilterAttributeExtractor extractor = new FilterAttributeExtractor(this.schema);
        Filter filter = query.getFilter();
        filter.accept(extractor, null);
        String[] filterAttnames = extractor.getAttributeNames();
        if (propertyNames != null && propertyNames.length == 1 && propertyNames[0].equals(defaultGeomName) && (filterAttnames.length == 0 || filterAttnames.length == 1 && filterAttnames[0].equals(defaultGeomName))) {
            try {
                SimpleFeatureType newSchema = DataUtilities.createSubType(this.schema, propertyNames);
                return this.createFeatureReader(typeName, this.getAttributesReader(false, query), newSchema);
            }
            catch (SchemaException se) {
                throw new DataSourceException("Error creating schema", se);
            }
        }
        try {
            return this.createFeatureReader(this.getSchema().getTypeName(), this.getAttributesReader(true, query), this.schema);
        }
        catch (SchemaException se) {
            throw new DataSourceException("Error creating schema", se);
        }
    }

    protected GeometryFactory getGeometryFactory(Hints hints) {
        CoordinateSequenceFactory csFactory;
        if (hints == null) {
            return new GeometryFactory();
        }
        GeometryFactory geometryFactory = (GeometryFactory)hints.get(Hints.JTS_GEOMETRY_FACTORY);
        if (geometryFactory == null && (csFactory = (CoordinateSequenceFactory)hints.get(Hints.JTS_COORDINATE_SEQUENCE_FACTORY)) != null) {
            geometryFactory = new GeometryFactory(csFactory);
        }
        if (geometryFactory == null) {
            geometryFactory = new GeometryFactory();
        }
        return geometryFactory;
    }

    protected FIDFeatureReader createFeatureReader(String typeName, ShapefileAttributeReader reader, SimpleFeatureType readerSchema) throws SchemaException {
        return new FIDFeatureReader(reader, new ShapeFIDReader(readerSchema, reader), readerSchema);
    }

    protected ShapefileAttributeReader getAttributesReader(boolean readDbf, Query q) throws IOException {
        ShapefileAttributeReader result;
        List<AttributeDescriptor> atts = this.schema == null ? this.readAttributes() : this.schema.getAttributeDescriptors();
        GeometryFactory geometryFactory = q != null ? this.getGeometryFactory(q.getHints()) : new GeometryFactory();
        ShapefileReader shapeReader = this.openShapeReader(geometryFactory);
        if (!readDbf) {
            LOGGER.fine("The DBF file won't be opened since no attributes will be read from it");
            atts = new ArrayList<AttributeDescriptor>(1);
            atts.add(this.schema.getGeometryDescriptor());
            result = new ShapefileAttributeReader(atts, shapeReader, null);
        } else {
            result = new ShapefileAttributeReader(atts, shapeReader, this.openDbfReader());
        }
        if (q != null) {
            Hints hints;
            Envelope bbox = new ReferencedEnvelope();
            bbox = (Envelope)q.getFilter().accept(ExtractBoundsFilterVisitor.BOUNDS_VISITOR, bbox);
            if (bbox != null && !bbox.isNull()) {
                result.setTargetBBox(bbox);
            }
            if ((hints = q.getHints()) != null) {
                Number simplificationDistance = (Number)hints.get(Hints.GEOMETRY_DISTANCE);
                if (simplificationDistance != null) {
                    result.setSimplificationDistance(simplificationDistance.doubleValue());
                }
                if (Boolean.TRUE.equals(hints.get(Hints.FEATURE_2D))) {
                    shapeReader.setFlatGeometry(true);
                }
            }
        }
        return result;
    }

    protected ShapefileReader openShapeReader(GeometryFactory gf) throws IOException {
        try {
            return new ShapefileReader(this.shpFiles, true, this.useMemoryMappedBuffer, gf);
        }
        catch (ShapefileException se) {
            throw new DataSourceException("Error creating ShapefileReader", se);
        }
    }

    protected DbaseFileReader openDbfReader() throws IOException {
        if (this.shpFiles.get(ShpFileType.DBF) == null) {
            return null;
        }
        if (this.isLocal() && !this.shpFiles.exists(ShpFileType.DBF)) {
            return null;
        }
        try {
            return new DbaseFileReader(this.shpFiles, this.useMemoryMappedBuffer, this.dbfCharset, this.dbfTimeZone);
        }
        catch (IOException e) {
            return null;
        }
    }

    protected IndexFile openIndexFile() throws IOException {
        if (this.shpFiles.get(ShpFileType.SHX) == null) {
            return null;
        }
        if (this.isLocal() && !this.shpFiles.exists(ShpFileType.SHX)) {
            return null;
        }
        try {
            return new IndexFile(this.shpFiles, this.useMemoryMappedBuffer);
        }
        catch (IOException e) {
            return null;
        }
    }

    protected PrjFileReader openPrjReader() throws IOException, FactoryException {
        if (this.shpFiles.get(ShpFileType.PRJ) == null) {
            return null;
        }
        if (this.isLocal() && !this.shpFiles.exists(ShpFileType.PRJ)) {
            return null;
        }
        try {
            return new PrjFileReader(this.shpFiles);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String[] getTypeNames() {
        return new String[]{this.getCurrentTypeName()};
    }

    protected String createFeatureTypeName() {
        return this.shpFiles.getTypeName();
    }

    protected String getCurrentTypeName() {
        return this.schema == null ? this.createFeatureTypeName() : this.schema.getTypeName();
    }

    protected void typeCheck(String requested) throws IOException {
        if (!this.getCurrentTypeName().equals(requested)) {
            throw new IOException("No such type : " + requested);
        }
    }

    @Override
    protected FeatureWriter<SimpleFeatureType, SimpleFeature> createFeatureWriter(String typeName, Transaction transaction) throws IOException {
        return null;
    }

    @Override
    public SimpleFeatureType getSchema(String typeName) throws IOException {
        this.typeCheck(typeName);
        return this.getSchema();
    }

    @Override
    public SimpleFeatureType getSchema() throws IOException {
        if (this.schema == null) {
            List<AttributeDescriptor> types = this.readAttributes();
            SimpleFeatureType parent = null;
            GeometryDescriptor geomDescriptor = (GeometryDescriptor)types.get(0);
            Class<?> geomBinding = geomDescriptor.getType().getBinding();
            if (geomBinding == Point.class || geomBinding == MultiPoint.class) {
                parent = BasicFeatureTypes.POINT;
            } else if (geomBinding == Polygon.class || geomBinding == MultiPolygon.class) {
                parent = BasicFeatureTypes.POLYGON;
            } else if (geomBinding == LineString.class || geomBinding == MultiLineString.class) {
                parent = BasicFeatureTypes.LINE;
            }
            SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
            builder.setDefaultGeometry(geomDescriptor.getLocalName());
            builder.addAll(types);
            builder.setName(this.createFeatureTypeName());
            if (this.namespace != null) {
                builder.setNamespaceURI(this.namespace);
            } else {
                builder.setNamespaceURI("http://www.opengis.net/gml");
            }
            builder.setAbstract(false);
            if (parent != null) {
                builder.setSuperType(parent);
            }
            this.schema = builder.buildFeatureType();
        }
        return this.schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<AttributeDescriptor> readAttributes() throws IOException {
        ShapefileReader shp = this.openShapeReader(new GeometryFactory());
        DbaseFileReader dbf = this.openDbfReader();
        CoordinateReferenceSystem crs = null;
        PrjFileReader prj = null;
        try {
            prj = this.openPrjReader();
            if (prj != null) {
                crs = prj.getCoodinateSystem();
            }
        }
        catch (FactoryException fe) {
            // empty catch block
        }
        AttributeTypeBuilder build = new AttributeTypeBuilder();
        ArrayList<AttributeDescriptor> attributes = new ArrayList<AttributeDescriptor>();
        try {
            Class geometryClass = JTSUtilities.findBestGeometryClass(shp.getHeader().getShapeType());
            build.setName(Classes.getShortName(geometryClass));
            build.setNillable(true);
            build.setCRS(crs);
            build.setBinding(geometryClass);
            GeometryType geometryType = build.buildGeometryType();
            attributes.add(build.buildDescriptor("the_geom", geometryType));
            HashSet<String> usedNames = new HashSet<String>();
            usedNames.add("the_geom");
            if (dbf != null) {
                DbaseFileHeader header = dbf.getHeader();
                int ii = header.getNumFields();
                for (int i = 0; i < ii; ++i) {
                    Class attributeClass = header.getFieldClass(i);
                    String name = header.getFieldName(i);
                    if (usedNames.contains(name)) {
                        String origional = name;
                        int count = 1;
                        name = name + count;
                        while (usedNames.contains(name)) {
                            name = origional + ++count;
                        }
                        build.addUserData(ORIGINAL_FIELD_NAME, origional);
                        build.addUserData(ORIGINAL_FIELD_DUPLICITY_COUNT, count);
                    }
                    usedNames.add(name);
                    int length = header.getFieldLength(i);
                    build.setNillable(true);
                    build.setLength(length);
                    build.setBinding(attributeClass);
                    attributes.add(build.buildDescriptor(name));
                }
            }
            ArrayList<AttributeDescriptor> arrayList = attributes;
            return arrayList;
        }
        finally {
            try {
                if (prj != null) {
                    prj.close();
                }
            }
            catch (IOException ioe) {}
            try {
                if (dbf != null) {
                    dbf.close();
                }
            }
            catch (IOException ioe) {}
            try {
                if (shp != null) {
                    shp.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected ReferencedEnvelope getBounds() throws DataSourceException {
        Envelope env;
        Channel in;
        block17: {
            in = null;
            ByteBuffer buffer = ByteBuffer.allocate(100);
            FileReader reader = new FileReader(){};
            in = this.shpFiles.getReadChannel(ShpFileType.SHP, reader);
            in.read(buffer);
            buffer.flip();
            ShapefileHeader header = new ShapefileHeader();
            header.read(buffer, true);
            ReferencedEnvelope bounds = new ReferencedEnvelope(this.schema.getCoordinateReferenceSystem());
            bounds.include(header.minX(), header.minY());
            bounds.include(header.minX(), header.minY());
            env = new Envelope(header.minX(), header.maxX(), header.minY(), header.maxY());
            if (this.schema == null) break block17;
            ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope(env, this.schema.getCoordinateReferenceSystem());
            in.close();
            return referencedEnvelope;
        }
        ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope(env, null);
        in.close();
        return referencedEnvelope;
        {
            catch (Throwable throwable) {
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new DataSourceException("Problem getting Bbox", ioe);
                }
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    @Override
    protected ReferencedEnvelope getBounds(Query query) throws IOException {
        if (query.getFilter().equals(Filter.INCLUDE)) {
            return this.getBounds();
        }
        return null;
    }

    @Override
    public SimpleFeatureSource getFeatureSource(String typeName) throws IOException {
        SimpleFeatureType featureType = this.getSchema(typeName);
        if (this.isWriteable) {
            if (this.getLockingManager() != null) {
                return new ShapefileFeatureLocking(this, this.getSupportedHints(), featureType);
            }
            return new ShapefileFeatureStore(this, this.getSupportedHints(), featureType);
        }
        return new ShapefileFeatureSource(this, this.getSupportedHints(), featureType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCount(Query query) throws IOException {
        if (query.getFilter() == Filter.INCLUDE) {
            IndexFile file = this.openIndexFile();
            if (file != null) {
                try {
                    int n = file.getRecordCount();
                    return n;
                }
                finally {
                    file.close();
                }
            }
            ShapefileReader reader = this.openShapeReader(new GeometryFactory());
            int count = -1;
            try {
                count = reader.getCount(count);
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                reader.close();
            }
            return count;
        }
        return super.getCount(query);
    }

    public String toString() {
        return "Shapefile datastore for :" + this.shpFiles.get(ShpFileType.SHP);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.shpFiles != null) {
            this.shpFiles.dispose();
            this.shpFiles = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.shpFiles != null && this.trace != null) {
            LOGGER.log(Level.SEVERE, "Undisposed of shapefile, you should call dispose() on all shapefile stores", this.trace);
        }
        this.dispose();
    }

    @Override
    protected Set getSupportedHints() {
        HashSet<Hints.Key> hints = new HashSet<Hints.Key>();
        hints.add(Hints.FEATURE_DETACHED);
        hints.add(Hints.JTS_GEOMETRY_FACTORY);
        hints.add(Hints.JTS_COORDINATE_SEQUENCE_FACTORY);
        hints.add(Hints.GEOMETRY_DISTANCE);
        return hints;
    }
}

