/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.util;

import org.apache.poi.ss.util.ExpandedDouble;
import org.apache.poi.ss.util.NormalisedDecimal;

public final class NumberToTextConverter {
    private static final long EXCEL_NAN_BITS = -276939487313920L;
    private static final int MAX_TEXT_LEN = 20;

    private NumberToTextConverter() {
    }

    public static String toText(double d) {
        return NumberToTextConverter.rawDoubleBitsToText(Double.doubleToLongBits(d));
    }

    static String rawDoubleBitsToText(long l) {
        boolean bl;
        long l2 = l;
        boolean bl2 = bl = l2 < 0L;
        if (bl) {
            l2 &= Long.MAX_VALUE;
        }
        if (l2 == 0L) {
            return bl ? "-0" : "0";
        }
        ExpandedDouble expandedDouble = new ExpandedDouble(l2);
        if (expandedDouble.getBinaryExponent() < -1022) {
            return bl ? "-0" : "0";
        }
        if (expandedDouble.getBinaryExponent() == 1024) {
            if (l2 == -276939487313920L) {
                return "3.484840871308E+308";
            }
            bl = false;
        }
        NormalisedDecimal normalisedDecimal = expandedDouble.normaliseBaseTen();
        StringBuilder stringBuilder = new StringBuilder(21);
        if (bl) {
            stringBuilder.append('-');
        }
        NumberToTextConverter.convertToText(stringBuilder, normalisedDecimal);
        return stringBuilder.toString();
    }

    private static void convertToText(StringBuilder stringBuilder, NormalisedDecimal normalisedDecimal) {
        String string;
        NormalisedDecimal normalisedDecimal2 = normalisedDecimal.roundUnits();
        int n = normalisedDecimal2.getDecimalExponent();
        if (Math.abs(n) > 98) {
            string = normalisedDecimal2.getSignificantDecimalDigitsLastDigitRounded();
            if (string.length() == 16) {
                ++n;
            }
        } else {
            string = normalisedDecimal2.getSignificantDecimalDigits();
        }
        int n2 = NumberToTextConverter.countSignifantDigits(string);
        if (n < 0) {
            NumberToTextConverter.formatLessThanOne(stringBuilder, string, n, n2);
        } else {
            NumberToTextConverter.formatGreaterThanOne(stringBuilder, string, n, n2);
        }
    }

    private static void formatLessThanOne(StringBuilder stringBuilder, String string, int n, int n2) {
        int n3 = -n - 1;
        int n4 = 2 + n3 + n2;
        if (NumberToTextConverter.needsScientificNotation(n4)) {
            stringBuilder.append(string.charAt(0));
            if (n2 > 1) {
                stringBuilder.append('.');
                stringBuilder.append(string.subSequence(1, n2));
            }
            stringBuilder.append("E-");
            NumberToTextConverter.appendExp(stringBuilder, -n);
            return;
        }
        stringBuilder.append("0.");
        for (int i = n3; i > 0; --i) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string.subSequence(0, n2));
    }

    private static void formatGreaterThanOne(StringBuilder stringBuilder, String string, int n, int n2) {
        if (n > 19) {
            stringBuilder.append(string.charAt(0));
            if (n2 > 1) {
                stringBuilder.append('.');
                stringBuilder.append(string.subSequence(1, n2));
            }
            stringBuilder.append("E+");
            NumberToTextConverter.appendExp(stringBuilder, n);
            return;
        }
        int n3 = n2 - n - 1;
        if (n3 > 0) {
            stringBuilder.append(string.subSequence(0, n + 1));
            stringBuilder.append('.');
            stringBuilder.append(string.subSequence(n + 1, n2));
            return;
        }
        stringBuilder.append(string.subSequence(0, n2));
        for (int i = -n3; i > 0; --i) {
            stringBuilder.append('0');
        }
    }

    private static boolean needsScientificNotation(int n) {
        return n > 20;
    }

    private static int countSignifantDigits(String string) {
        int n = string.length() - 1;
        while (string.charAt(n) == '0') {
            if (--n >= 0) continue;
            throw new RuntimeException("No non-zero digits found");
        }
        return n + 1;
    }

    private static void appendExp(StringBuilder stringBuilder, int n) {
        if (n < 10) {
            stringBuilder.append('0');
            stringBuilder.append((char)(48 + n));
            return;
        }
        stringBuilder.append(n);
    }
}

