/*
 * Decompiled with CFR 0.152.
 */
package javax.measure;

import java.io.Serializable;
import javax.measure.Measurable;
import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;

public abstract class Measure<V, Q extends Quantity>
implements Measurable<Q>,
Serializable {
    protected Measure() {
    }

    public static <Q extends Quantity> Measure<java.lang.Double, Q> valueOf(double d, Unit<Q> unit) {
        return new Double<Q>(d, unit);
    }

    public static <Q extends Quantity> Measure<java.lang.Long, Q> valueOf(long l, Unit<Q> unit) {
        return new Long<Q>(l, unit);
    }

    public static <Q extends Quantity> Measure<java.lang.Float, Q> valueOf(float f, Unit<Q> unit) {
        return new Float<Q>(f, unit);
    }

    public static <Q extends Quantity> Measure<java.lang.Integer, Q> valueOf(int n, Unit<Q> unit) {
        return new Integer<Q>(n, unit);
    }

    public abstract V getValue();

    public abstract Unit<Q> getUnit();

    public abstract Measure<V, Q> to(Unit<Q> var1);

    @Override
    public abstract double doubleValue(Unit<Q> var1);

    @Override
    public long longValue(Unit<Q> unit) throws ArithmeticException {
        double d = this.doubleValue(unit);
        if (java.lang.Double.isNaN(d) || d < -9.223372036854776E18 || d > 9.223372036854776E18) {
            throw new ArithmeticException(d + " " + unit + " cannot be represented as long");
        }
        return Math.round(d);
    }

    public float floatValue(Unit<Q> unit) {
        return (float)this.doubleValue(unit);
    }

    public int intValue(Unit<Q> unit) {
        long l = this.longValue(unit);
        if (l > java.lang.Integer.MAX_VALUE || l < java.lang.Integer.MIN_VALUE) {
            throw new ArithmeticException("Overflow");
        }
        return (int)l;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Measure)) {
            return false;
        }
        Measure measure = (Measure)object;
        return this.getUnit().equals(measure.getUnit()) && this.getValue().equals(measure.getValue());
    }

    public int hashCode() {
        return this.getUnit().hashCode() + this.getValue().hashCode();
    }

    @Override
    public int compareTo(Measurable<Q> measurable) {
        return java.lang.Double.compare(this.doubleValue(this.getUnit()), measurable.doubleValue(this.getUnit()));
    }

    private static final class Integer<Q extends Quantity>
    extends Measure<java.lang.Integer, Q> {
        private final int _value;
        private final Unit<Q> _unit;
        private static final long serialVersionUID = 1L;

        public Integer(int n, Unit<Q> unit) {
            this._value = n;
            this._unit = unit;
        }

        @Override
        public Unit<Q> getUnit() {
            return this._unit;
        }

        @Override
        public java.lang.Integer getValue() {
            return this._value;
        }

        @Override
        public Measure<java.lang.Integer, Q> to(Unit<Q> unit) {
            if (unit == this._unit || unit.equals(this._unit)) {
                return this;
            }
            return new Integer<Q>(this.intValue(unit), unit);
        }

        @Override
        public double doubleValue(Unit<Q> unit) {
            if (unit == this._unit || unit.equals(this._unit)) {
                return this._value;
            }
            return this._unit.getConverterTo(unit).convert(this._value);
        }

        @Override
        public long longValue(Unit<Q> unit) throws ArithmeticException {
            if (unit == this._unit || unit.equals(this._unit)) {
                return this._value;
            }
            return super.longValue(unit);
        }
    }

    private static final class Float<Q extends Quantity>
    extends Measure<java.lang.Float, Q> {
        private final float _value;
        private final Unit<Q> _unit;
        private static final long serialVersionUID = 1L;

        public Float(float f, Unit<Q> unit) {
            this._value = f;
            this._unit = unit;
        }

        @Override
        public Unit<Q> getUnit() {
            return this._unit;
        }

        @Override
        public java.lang.Float getValue() {
            return java.lang.Float.valueOf(this._value);
        }

        @Override
        public Measure<java.lang.Float, Q> to(Unit<Q> unit) {
            if (unit == this._unit || unit.equals(this._unit)) {
                return this;
            }
            return new Float<Q>(this.floatValue(unit), unit);
        }

        @Override
        public double doubleValue(Unit<Q> unit) {
            if (unit == this._unit || unit.equals(this._unit)) {
                return this._value;
            }
            return this._unit.getConverterTo(unit).convert(this._value);
        }
    }

    private static final class Long<Q extends Quantity>
    extends Measure<java.lang.Long, Q> {
        private final long _value;
        private final Unit<Q> _unit;
        private static final long serialVersionUID = 1L;

        public Long(long l, Unit<Q> unit) {
            this._value = l;
            this._unit = unit;
        }

        @Override
        public Unit<Q> getUnit() {
            return this._unit;
        }

        @Override
        public java.lang.Long getValue() {
            return this._value;
        }

        @Override
        public Measure<java.lang.Long, Q> to(Unit<Q> unit) {
            if (unit == this._unit || unit.equals(this._unit)) {
                return this;
            }
            return new Long<Q>(this.longValue(unit), unit);
        }

        @Override
        public double doubleValue(Unit<Q> unit) {
            if (unit == this._unit || unit.equals(this._unit)) {
                return this._value;
            }
            return this._unit.getConverterTo(unit).convert(this._value);
        }

        @Override
        public long longValue(Unit<Q> unit) throws ArithmeticException {
            if (unit == this._unit || unit.equals(this._unit)) {
                return this._value;
            }
            return super.longValue(unit);
        }
    }

    private static final class Double<Q extends Quantity>
    extends Measure<java.lang.Double, Q> {
        private final double _value;
        private final Unit<Q> _unit;
        private static final long serialVersionUID = 1L;

        public Double(double d, Unit<Q> unit) {
            this._value = d;
            this._unit = unit;
        }

        @Override
        public Unit<Q> getUnit() {
            return this._unit;
        }

        @Override
        public java.lang.Double getValue() {
            return this._value;
        }

        @Override
        public Measure<java.lang.Double, Q> to(Unit<Q> unit) {
            if (unit == this._unit || unit.equals(this._unit)) {
                return this;
            }
            return new Double<Q>(this.doubleValue(unit), unit);
        }

        @Override
        public double doubleValue(Unit<Q> unit) {
            if (unit == this._unit || unit.equals(this._unit)) {
                return this._value;
            }
            return this._unit.getConverterTo(unit).convert(this._value);
        }
    }
}

