/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.valid;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.MCPointInRing;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeIntersection;
import com.vividsolutions.jts.geomgraph.EdgeIntersectionList;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.operation.valid.ConnectedInteriorTester;
import com.vividsolutions.jts.operation.valid.ConsistentAreaTester;
import com.vividsolutions.jts.operation.valid.IndexedNestedRingTester;
import com.vividsolutions.jts.operation.valid.TopologyValidationError;
import com.vividsolutions.jts.util.Assert;
import java.util.Iterator;
import java.util.TreeSet;

public class IsValidOp {
    private Geometry parentGeometry;
    private boolean isSelfTouchingRingFormingHoleValid = false;
    private TopologyValidationError validErr;

    public static boolean isValid(Geometry geometry) {
        IsValidOp isValidOp = new IsValidOp(geometry);
        return isValidOp.isValid();
    }

    public static boolean isValid(Coordinate coordinate) {
        if (Double.isNaN(coordinate.x)) {
            return false;
        }
        if (Double.isInfinite(coordinate.x)) {
            return false;
        }
        if (Double.isNaN(coordinate.y)) {
            return false;
        }
        return !Double.isInfinite(coordinate.y);
    }

    public static Coordinate findPtNotNode(Coordinate[] coordinateArray, LinearRing linearRing, GeometryGraph geometryGraph) {
        Edge edge = geometryGraph.findEdge(linearRing);
        EdgeIntersectionList edgeIntersectionList = edge.getEdgeIntersectionList();
        for (int i = 0; i < coordinateArray.length; ++i) {
            Coordinate coordinate = coordinateArray[i];
            if (edgeIntersectionList.isIntersection(coordinate)) continue;
            return coordinate;
        }
        return null;
    }

    public IsValidOp(Geometry geometry) {
        this.parentGeometry = geometry;
    }

    public boolean isValid() {
        this.checkValid(this.parentGeometry);
        return this.validErr == null;
    }

    private void checkValid(Geometry geometry) {
        this.validErr = null;
        if (geometry.isEmpty()) {
            return;
        }
        if (geometry instanceof Point) {
            this.checkValid((Point)geometry);
        } else if (geometry instanceof MultiPoint) {
            this.checkValid((MultiPoint)geometry);
        } else if (geometry instanceof LinearRing) {
            this.checkValid((LinearRing)geometry);
        } else if (geometry instanceof LineString) {
            this.checkValid((LineString)geometry);
        } else if (geometry instanceof Polygon) {
            this.checkValid((Polygon)geometry);
        } else if (geometry instanceof MultiPolygon) {
            this.checkValid((MultiPolygon)geometry);
        } else if (geometry instanceof GeometryCollection) {
            this.checkValid((GeometryCollection)geometry);
        } else {
            throw new UnsupportedOperationException(geometry.getClass().getName());
        }
    }

    private void checkValid(Point point) {
        this.checkInvalidCoordinates(point.getCoordinates());
    }

    private void checkValid(MultiPoint multiPoint) {
        this.checkInvalidCoordinates(multiPoint.getCoordinates());
    }

    private void checkValid(LineString lineString) {
        this.checkInvalidCoordinates(lineString.getCoordinates());
        if (this.validErr != null) {
            return;
        }
        GeometryGraph geometryGraph = new GeometryGraph(0, lineString);
        this.checkTooFewPoints(geometryGraph);
    }

    private void checkValid(LinearRing linearRing) {
        this.checkInvalidCoordinates(linearRing.getCoordinates());
        if (this.validErr != null) {
            return;
        }
        this.checkClosedRing(linearRing);
        if (this.validErr != null) {
            return;
        }
        GeometryGraph geometryGraph = new GeometryGraph(0, linearRing);
        this.checkTooFewPoints(geometryGraph);
        if (this.validErr != null) {
            return;
        }
        RobustLineIntersector robustLineIntersector = new RobustLineIntersector();
        geometryGraph.computeSelfNodes(robustLineIntersector, true);
        this.checkNoSelfIntersectingRings(geometryGraph);
    }

    private void checkValid(Polygon polygon) {
        this.checkInvalidCoordinates(polygon);
        if (this.validErr != null) {
            return;
        }
        this.checkClosedRings(polygon);
        if (this.validErr != null) {
            return;
        }
        GeometryGraph geometryGraph = new GeometryGraph(0, polygon);
        this.checkTooFewPoints(geometryGraph);
        if (this.validErr != null) {
            return;
        }
        this.checkConsistentArea(geometryGraph);
        if (this.validErr != null) {
            return;
        }
        if (!this.isSelfTouchingRingFormingHoleValid) {
            this.checkNoSelfIntersectingRings(geometryGraph);
            if (this.validErr != null) {
                return;
            }
        }
        this.checkHolesInShell(polygon, geometryGraph);
        if (this.validErr != null) {
            return;
        }
        this.checkHolesNotNested(polygon, geometryGraph);
        if (this.validErr != null) {
            return;
        }
        this.checkConnectedInteriors(geometryGraph);
    }

    private void checkValid(MultiPolygon multiPolygon) {
        Polygon polygon;
        int n;
        for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
            Polygon polygon2 = (Polygon)multiPolygon.getGeometryN(i);
            this.checkInvalidCoordinates(polygon2);
            if (this.validErr != null) {
                return;
            }
            this.checkClosedRings(polygon2);
            if (this.validErr == null) continue;
            return;
        }
        GeometryGraph geometryGraph = new GeometryGraph(0, multiPolygon);
        this.checkTooFewPoints(geometryGraph);
        if (this.validErr != null) {
            return;
        }
        this.checkConsistentArea(geometryGraph);
        if (this.validErr != null) {
            return;
        }
        if (!this.isSelfTouchingRingFormingHoleValid) {
            this.checkNoSelfIntersectingRings(geometryGraph);
            if (this.validErr != null) {
                return;
            }
        }
        for (n = 0; n < multiPolygon.getNumGeometries(); ++n) {
            polygon = (Polygon)multiPolygon.getGeometryN(n);
            this.checkHolesInShell(polygon, geometryGraph);
            if (this.validErr == null) continue;
            return;
        }
        for (n = 0; n < multiPolygon.getNumGeometries(); ++n) {
            polygon = (Polygon)multiPolygon.getGeometryN(n);
            this.checkHolesNotNested(polygon, geometryGraph);
            if (this.validErr == null) continue;
            return;
        }
        this.checkShellsNotNested(multiPolygon, geometryGraph);
        if (this.validErr != null) {
            return;
        }
        this.checkConnectedInteriors(geometryGraph);
    }

    private void checkValid(GeometryCollection geometryCollection) {
        for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
            Geometry geometry = geometryCollection.getGeometryN(i);
            this.checkValid(geometry);
            if (this.validErr == null) continue;
            return;
        }
    }

    private void checkInvalidCoordinates(Coordinate[] coordinateArray) {
        for (int i = 0; i < coordinateArray.length; ++i) {
            if (IsValidOp.isValid(coordinateArray[i])) continue;
            this.validErr = new TopologyValidationError(10, coordinateArray[i]);
            return;
        }
    }

    private void checkInvalidCoordinates(Polygon polygon) {
        this.checkInvalidCoordinates(polygon.getExteriorRing().getCoordinates());
        if (this.validErr != null) {
            return;
        }
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            this.checkInvalidCoordinates(polygon.getInteriorRingN(i).getCoordinates());
            if (this.validErr == null) continue;
            return;
        }
    }

    private void checkClosedRings(Polygon polygon) {
        this.checkClosedRing((LinearRing)polygon.getExteriorRing());
        if (this.validErr != null) {
            return;
        }
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            this.checkClosedRing((LinearRing)polygon.getInteriorRingN(i));
            if (this.validErr == null) continue;
            return;
        }
    }

    private void checkClosedRing(LinearRing linearRing) {
        if (!linearRing.isClosed()) {
            Coordinate coordinate = null;
            if (linearRing.getNumPoints() >= 1) {
                coordinate = linearRing.getCoordinateN(0);
            }
            this.validErr = new TopologyValidationError(11, coordinate);
        }
    }

    private void checkTooFewPoints(GeometryGraph geometryGraph) {
        if (geometryGraph.hasTooFewPoints()) {
            this.validErr = new TopologyValidationError(9, geometryGraph.getInvalidPoint());
            return;
        }
    }

    private void checkConsistentArea(GeometryGraph geometryGraph) {
        ConsistentAreaTester consistentAreaTester = new ConsistentAreaTester(geometryGraph);
        boolean bl = consistentAreaTester.isNodeConsistentArea();
        if (!bl) {
            this.validErr = new TopologyValidationError(5, consistentAreaTester.getInvalidPoint());
            return;
        }
        if (consistentAreaTester.hasDuplicateRings()) {
            this.validErr = new TopologyValidationError(8, consistentAreaTester.getInvalidPoint());
        }
    }

    private void checkNoSelfIntersectingRings(GeometryGraph geometryGraph) {
        Iterator iterator = geometryGraph.getEdgeIterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            this.checkNoSelfIntersectingRing(edge.getEdgeIntersectionList());
            if (this.validErr == null) continue;
            return;
        }
    }

    private void checkNoSelfIntersectingRing(EdgeIntersectionList edgeIntersectionList) {
        TreeSet<Coordinate> treeSet = new TreeSet<Coordinate>();
        boolean bl = true;
        Iterator iterator = edgeIntersectionList.iterator();
        while (iterator.hasNext()) {
            EdgeIntersection edgeIntersection = (EdgeIntersection)iterator.next();
            if (bl) {
                bl = false;
                continue;
            }
            if (treeSet.contains(edgeIntersection.coord)) {
                this.validErr = new TopologyValidationError(6, edgeIntersection.coord);
                return;
            }
            treeSet.add(edgeIntersection.coord);
        }
    }

    private void checkHolesInShell(Polygon polygon, GeometryGraph geometryGraph) {
        LinearRing linearRing = (LinearRing)polygon.getExteriorRing();
        MCPointInRing mCPointInRing = new MCPointInRing(linearRing);
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            boolean bl;
            LinearRing linearRing2 = (LinearRing)polygon.getInteriorRingN(i);
            Coordinate coordinate = IsValidOp.findPtNotNode(linearRing2.getCoordinates(), linearRing, geometryGraph);
            if (coordinate == null) {
                return;
            }
            boolean bl2 = bl = !mCPointInRing.isInside(coordinate);
            if (!bl) continue;
            this.validErr = new TopologyValidationError(2, coordinate);
            return;
        }
    }

    private void checkHolesNotNested(Polygon polygon, GeometryGraph geometryGraph) {
        int n;
        IndexedNestedRingTester indexedNestedRingTester = new IndexedNestedRingTester(geometryGraph);
        for (n = 0; n < polygon.getNumInteriorRing(); ++n) {
            LinearRing linearRing = (LinearRing)polygon.getInteriorRingN(n);
            indexedNestedRingTester.add(linearRing);
        }
        n = indexedNestedRingTester.isNonNested() ? 1 : 0;
        if (n == 0) {
            this.validErr = new TopologyValidationError(3, indexedNestedRingTester.getNestedPoint());
        }
    }

    private void checkShellsNotNested(MultiPolygon multiPolygon, GeometryGraph geometryGraph) {
        for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
            Polygon polygon = (Polygon)multiPolygon.getGeometryN(i);
            LinearRing linearRing = (LinearRing)polygon.getExteriorRing();
            for (int j = 0; j < multiPolygon.getNumGeometries(); ++j) {
                if (i == j) continue;
                Polygon polygon2 = (Polygon)multiPolygon.getGeometryN(j);
                this.checkShellNotNested(linearRing, polygon2, geometryGraph);
                if (this.validErr == null) continue;
                return;
            }
        }
    }

    private void checkShellNotNested(LinearRing linearRing, Polygon polygon, GeometryGraph geometryGraph) {
        Coordinate[] coordinateArray = linearRing.getCoordinates();
        LinearRing linearRing2 = (LinearRing)polygon.getExteriorRing();
        Coordinate[] coordinateArray2 = linearRing2.getCoordinates();
        Coordinate coordinate = IsValidOp.findPtNotNode(coordinateArray, linearRing2, geometryGraph);
        if (coordinate == null) {
            return;
        }
        boolean bl = CGAlgorithms.isPointInRing(coordinate, coordinateArray2);
        if (!bl) {
            return;
        }
        if (polygon.getNumInteriorRing() <= 0) {
            this.validErr = new TopologyValidationError(7, coordinate);
            return;
        }
        Coordinate coordinate2 = null;
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            LinearRing linearRing3 = (LinearRing)polygon.getInteriorRingN(i);
            coordinate2 = this.checkShellInsideHole(linearRing, linearRing3, geometryGraph);
            if (coordinate2 != null) continue;
            return;
        }
        this.validErr = new TopologyValidationError(7, coordinate2);
    }

    private Coordinate checkShellInsideHole(LinearRing linearRing, LinearRing linearRing2, GeometryGraph geometryGraph) {
        boolean bl;
        Coordinate[] coordinateArray = linearRing.getCoordinates();
        Coordinate[] coordinateArray2 = linearRing2.getCoordinates();
        Coordinate coordinate = IsValidOp.findPtNotNode(coordinateArray, linearRing2, geometryGraph);
        if (coordinate != null && !(bl = CGAlgorithms.isPointInRing(coordinate, coordinateArray2))) {
            return coordinate;
        }
        Coordinate coordinate2 = IsValidOp.findPtNotNode(coordinateArray2, linearRing, geometryGraph);
        if (coordinate2 != null) {
            boolean bl2 = CGAlgorithms.isPointInRing(coordinate2, coordinateArray);
            if (bl2) {
                return coordinate2;
            }
            return null;
        }
        Assert.shouldNeverReachHere("points in shell and hole appear to be equal");
        return null;
    }

    private void checkConnectedInteriors(GeometryGraph geometryGraph) {
        ConnectedInteriorTester connectedInteriorTester = new ConnectedInteriorTester(geometryGraph);
        if (!connectedInteriorTester.isInteriorsConnected()) {
            this.validErr = new TopologyValidationError(4, connectedInteriorTester.getCoordinate());
        }
    }
}

