/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.predicate;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.LineString;
import java.util.List;

public class SegmentIntersectionTester {
    private LineIntersector li = new RobustLineIntersector();
    private boolean hasIntersection = false;
    private Coordinate pt00 = new Coordinate();
    private Coordinate pt01 = new Coordinate();
    private Coordinate pt10 = new Coordinate();
    private Coordinate pt11 = new Coordinate();

    public boolean hasIntersectionWithLineStrings(LineString lineString, List list) {
        for (LineString lineString2 : list) {
            this.hasIntersectionWithEnvelopeFilter(lineString, lineString2);
            if (!this.hasIntersection) continue;
            break;
        }
        return this.hasIntersection;
    }

    private boolean hasIntersectionWithEnvelopeFilter(LineString lineString, LineString lineString2) {
        CoordinateSequence coordinateSequence = lineString.getCoordinateSequence();
        CoordinateSequence coordinateSequence2 = lineString2.getCoordinateSequence();
        Envelope envelope = lineString.getEnvelopeInternal();
        for (int i = 1; i < coordinateSequence2.size() && !this.hasIntersection; ++i) {
            coordinateSequence2.getCoordinate(i - 1, this.pt10);
            coordinateSequence2.getCoordinate(i, this.pt11);
            if (!envelope.intersects(new Envelope(this.pt10, this.pt11))) continue;
            for (int j = 1; j < coordinateSequence.size() && !this.hasIntersection; ++j) {
                coordinateSequence.getCoordinate(j - 1, this.pt00);
                coordinateSequence.getCoordinate(j, this.pt01);
                this.li.computeIntersection(this.pt00, this.pt01, this.pt10, this.pt11);
                if (!this.li.hasIntersection()) continue;
                this.hasIntersection = true;
            }
        }
        return this.hasIntersection;
    }
}

