/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.overlay.snap;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.LineSegment;

public class LineStringSnapper {
    private double snapTolerance = 0.0;
    private Coordinate[] srcPts;
    private LineSegment seg = new LineSegment();
    private boolean allowSnappingToSourceVertices = false;
    private boolean isClosed = false;

    public LineStringSnapper(Coordinate[] coordinateArray, double d) {
        this.srcPts = coordinateArray;
        this.isClosed = LineStringSnapper.isClosed(coordinateArray);
        this.snapTolerance = d;
    }

    public void setAllowSnappingToSourceVertices(boolean bl) {
        this.allowSnappingToSourceVertices = bl;
    }

    private static boolean isClosed(Coordinate[] coordinateArray) {
        if (coordinateArray.length <= 1) {
            return false;
        }
        return coordinateArray[0].equals2D(coordinateArray[coordinateArray.length - 1]);
    }

    public Coordinate[] snapTo(Coordinate[] coordinateArray) {
        CoordinateList coordinateList = new CoordinateList(this.srcPts);
        this.snapVertices(coordinateList, coordinateArray);
        this.snapSegments(coordinateList, coordinateArray);
        Coordinate[] coordinateArray2 = coordinateList.toCoordinateArray();
        return coordinateArray2;
    }

    private void snapVertices(CoordinateList coordinateList, Coordinate[] coordinateArray) {
        int n = this.isClosed ? coordinateList.size() - 1 : coordinateList.size();
        for (int i = 0; i < n; ++i) {
            Coordinate coordinate = (Coordinate)coordinateList.get(i);
            Coordinate coordinate2 = this.findSnapForVertex(coordinate, coordinateArray);
            if (coordinate2 == null) continue;
            coordinateList.set(i, new Coordinate(coordinate2));
            if (i != 0 || !this.isClosed) continue;
            coordinateList.set(coordinateList.size() - 1, new Coordinate(coordinate2));
        }
    }

    private Coordinate findSnapForVertex(Coordinate coordinate, Coordinate[] coordinateArray) {
        for (int i = 0; i < coordinateArray.length; ++i) {
            if (coordinate.equals2D(coordinateArray[i])) {
                return null;
            }
            if (!(coordinate.distance(coordinateArray[i]) < this.snapTolerance)) continue;
            return coordinateArray[i];
        }
        return null;
    }

    private void snapSegments(CoordinateList coordinateList, Coordinate[] coordinateArray) {
        if (coordinateArray.length == 0) {
            return;
        }
        int n = coordinateArray.length;
        if (coordinateArray[0].equals2D(coordinateArray[coordinateArray.length - 1])) {
            n = coordinateArray.length - 1;
        }
        for (int i = 0; i < n; ++i) {
            Coordinate coordinate = coordinateArray[i];
            int n2 = this.findSegmentIndexToSnap(coordinate, coordinateList);
            if (n2 < 0) continue;
            coordinateList.add(n2 + 1, new Coordinate(coordinate), false);
        }
    }

    private int findSegmentIndexToSnap(Coordinate coordinate, CoordinateList coordinateList) {
        double d = Double.MAX_VALUE;
        int n = -1;
        for (int i = 0; i < coordinateList.size() - 1; ++i) {
            this.seg.p0 = (Coordinate)coordinateList.get(i);
            this.seg.p1 = (Coordinate)coordinateList.get(i + 1);
            if (this.seg.p0.equals2D(coordinate) || this.seg.p1.equals2D(coordinate)) {
                if (this.allowSnappingToSourceVertices) continue;
                return -1;
            }
            double d2 = this.seg.distance(coordinate);
            if (!(d2 < this.snapTolerance) || !(d2 < d)) continue;
            d = d2;
            n = i;
        }
        return n;
    }
}

