/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.geomgraph.TopologyLocation;

public class Label {
    TopologyLocation[] elt = new TopologyLocation[2];

    public static Label toLineLabel(Label label) {
        Label label2 = new Label(-1);
        for (int i = 0; i < 2; ++i) {
            label2.setLocation(i, label.getLocation(i));
        }
        return label2;
    }

    public Label(int n) {
        this.elt[0] = new TopologyLocation(n);
        this.elt[1] = new TopologyLocation(n);
    }

    public Label(int n, int n2) {
        this.elt[0] = new TopologyLocation(-1);
        this.elt[1] = new TopologyLocation(-1);
        this.elt[n].setLocation(n2);
    }

    public Label(int n, int n2, int n3) {
        this.elt[0] = new TopologyLocation(n, n2, n3);
        this.elt[1] = new TopologyLocation(n, n2, n3);
    }

    public Label(int n, int n2, int n3, int n4) {
        this.elt[0] = new TopologyLocation(-1, -1, -1);
        this.elt[1] = new TopologyLocation(-1, -1, -1);
        this.elt[n].setLocations(n2, n3, n4);
    }

    public Label(Label label) {
        this.elt[0] = new TopologyLocation(label.elt[0]);
        this.elt[1] = new TopologyLocation(label.elt[1]);
    }

    public void flip() {
        this.elt[0].flip();
        this.elt[1].flip();
    }

    public int getLocation(int n, int n2) {
        return this.elt[n].get(n2);
    }

    public int getLocation(int n) {
        return this.elt[n].get(0);
    }

    public void setLocation(int n, int n2, int n3) {
        this.elt[n].setLocation(n2, n3);
    }

    public void setLocation(int n, int n2) {
        this.elt[n].setLocation(0, n2);
    }

    public void setAllLocations(int n, int n2) {
        this.elt[n].setAllLocations(n2);
    }

    public void setAllLocationsIfNull(int n, int n2) {
        this.elt[n].setAllLocationsIfNull(n2);
    }

    public void merge(Label label) {
        for (int i = 0; i < 2; ++i) {
            if (this.elt[i] == null && label.elt[i] != null) {
                this.elt[i] = new TopologyLocation(label.elt[i]);
                continue;
            }
            this.elt[i].merge(label.elt[i]);
        }
    }

    public int getGeometryCount() {
        int n = 0;
        if (!this.elt[0].isNull()) {
            ++n;
        }
        if (!this.elt[1].isNull()) {
            ++n;
        }
        return n;
    }

    public boolean isNull(int n) {
        return this.elt[n].isNull();
    }

    public boolean isAnyNull(int n) {
        return this.elt[n].isAnyNull();
    }

    public boolean isArea() {
        return this.elt[0].isArea() || this.elt[1].isArea();
    }

    public boolean isArea(int n) {
        return this.elt[n].isArea();
    }

    public boolean isLine(int n) {
        return this.elt[n].isLine();
    }

    public boolean allPositionsEqual(int n, int n2) {
        return this.elt[n].allPositionsEqual(n2);
    }

    public void toLine(int n) {
        if (this.elt[n].isArea()) {
            this.elt[n] = new TopologyLocation(this.elt[n].location[0]);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.elt[0] != null) {
            stringBuffer.append("A:");
            stringBuffer.append(this.elt[0].toString());
        }
        if (this.elt[1] != null) {
            stringBuffer.append(" B:");
            stringBuffer.append(this.elt[1].toString());
        }
        return stringBuffer.toString();
    }
}

