/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeEnd;
import com.vividsolutions.jts.geomgraph.EdgeRing;
import com.vividsolutions.jts.geomgraph.Label;
import java.io.PrintStream;

public class DirectedEdge
extends EdgeEnd {
    protected boolean isForward;
    private boolean isInResult = false;
    private boolean isVisited = false;
    private DirectedEdge sym;
    private DirectedEdge next;
    private DirectedEdge nextMin;
    private EdgeRing edgeRing;
    private EdgeRing minEdgeRing;
    private int[] depth = new int[]{0, -999, -999};

    public DirectedEdge(Edge edge, boolean bl) {
        super(edge);
        this.isForward = bl;
        if (bl) {
            this.init(edge.getCoordinate(0), edge.getCoordinate(1));
        } else {
            int n = edge.getNumPoints() - 1;
            this.init(edge.getCoordinate(n), edge.getCoordinate(n - 1));
        }
        this.computeDirectedLabel();
    }

    @Override
    public Edge getEdge() {
        return this.edge;
    }

    public void setInResult(boolean bl) {
        this.isInResult = bl;
    }

    public boolean isInResult() {
        return this.isInResult;
    }

    public boolean isVisited() {
        return this.isVisited;
    }

    public void setVisited(boolean bl) {
        this.isVisited = bl;
    }

    public void setEdgeRing(EdgeRing edgeRing) {
        this.edgeRing = edgeRing;
    }

    public EdgeRing getEdgeRing() {
        return this.edgeRing;
    }

    public void setMinEdgeRing(EdgeRing edgeRing) {
        this.minEdgeRing = edgeRing;
    }

    public EdgeRing getMinEdgeRing() {
        return this.minEdgeRing;
    }

    public int getDepthDelta() {
        int n = this.edge.getDepthDelta();
        if (!this.isForward) {
            n = -n;
        }
        return n;
    }

    public void setVisitedEdge(boolean bl) {
        this.setVisited(bl);
        this.sym.setVisited(bl);
    }

    public DirectedEdge getSym() {
        return this.sym;
    }

    public boolean isForward() {
        return this.isForward;
    }

    public void setSym(DirectedEdge directedEdge) {
        this.sym = directedEdge;
    }

    public DirectedEdge getNext() {
        return this.next;
    }

    public void setNext(DirectedEdge directedEdge) {
        this.next = directedEdge;
    }

    public DirectedEdge getNextMin() {
        return this.nextMin;
    }

    public void setNextMin(DirectedEdge directedEdge) {
        this.nextMin = directedEdge;
    }

    public boolean isLineEdge() {
        boolean bl = this.label.isLine(0) || this.label.isLine(1);
        boolean bl2 = !this.label.isArea(0) || this.label.allPositionsEqual(0, 2);
        boolean bl3 = !this.label.isArea(1) || this.label.allPositionsEqual(1, 2);
        return bl && bl2 && bl3;
    }

    public boolean isInteriorAreaEdge() {
        boolean bl = true;
        for (int i = 0; i < 2; ++i) {
            if (this.label.isArea(i) && this.label.getLocation(i, 1) == 0 && this.label.getLocation(i, 2) == 0) continue;
            bl = false;
        }
        return bl;
    }

    private void computeDirectedLabel() {
        this.label = new Label(this.edge.getLabel());
        if (!this.isForward) {
            this.label.flip();
        }
    }

    @Override
    public void print(PrintStream printStream) {
        super.print(printStream);
        printStream.print(" " + this.depth[1] + "/" + this.depth[2]);
        printStream.print(" (" + this.getDepthDelta() + ")");
        if (this.isInResult) {
            printStream.print(" inResult");
        }
    }
}

