/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.CoordinateSequenceComparator;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.GeometryFilter;
import com.vividsolutions.jts.util.Assert;
import java.util.Arrays;
import java.util.TreeSet;

public class GeometryCollection
extends Geometry {
    private static final long serialVersionUID = -5694727726395021467L;
    protected Geometry[] geometries;

    public GeometryCollection(Geometry[] geometryArray, GeometryFactory geometryFactory) {
        super(geometryFactory);
        if (geometryArray == null) {
            geometryArray = new Geometry[]{};
        }
        if (GeometryCollection.hasNullElements(geometryArray)) {
            throw new IllegalArgumentException("geometries must not contain null elements");
        }
        this.geometries = geometryArray;
    }

    @Override
    public Coordinate getCoordinate() {
        if (this.isEmpty()) {
            return null;
        }
        return this.geometries[0].getCoordinate();
    }

    @Override
    public Coordinate[] getCoordinates() {
        Coordinate[] coordinateArray = new Coordinate[this.getNumPoints()];
        int n = -1;
        for (int i = 0; i < this.geometries.length; ++i) {
            Coordinate[] coordinateArray2 = this.geometries[i].getCoordinates();
            for (int j = 0; j < coordinateArray2.length; ++j) {
                coordinateArray[++n] = coordinateArray2[j];
            }
        }
        return coordinateArray;
    }

    @Override
    public boolean isEmpty() {
        for (int i = 0; i < this.geometries.length; ++i) {
            if (this.geometries[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getDimension() {
        int n = -1;
        for (int i = 0; i < this.geometries.length; ++i) {
            n = Math.max(n, this.geometries[i].getDimension());
        }
        return n;
    }

    @Override
    public int getBoundaryDimension() {
        int n = -1;
        for (int i = 0; i < this.geometries.length; ++i) {
            n = Math.max(n, this.geometries[i].getBoundaryDimension());
        }
        return n;
    }

    @Override
    public int getNumGeometries() {
        return this.geometries.length;
    }

    @Override
    public Geometry getGeometryN(int n) {
        return this.geometries[n];
    }

    @Override
    public int getNumPoints() {
        int n = 0;
        for (int i = 0; i < this.geometries.length; ++i) {
            n += this.geometries[i].getNumPoints();
        }
        return n;
    }

    @Override
    public String getGeometryType() {
        return "GeometryCollection";
    }

    @Override
    public Geometry getBoundary() {
        this.checkNotGeometryCollection(this);
        Assert.shouldNeverReachHere();
        return null;
    }

    @Override
    public double getArea() {
        double d = 0.0;
        for (int i = 0; i < this.geometries.length; ++i) {
            d += this.geometries[i].getArea();
        }
        return d;
    }

    @Override
    public double getLength() {
        double d = 0.0;
        for (int i = 0; i < this.geometries.length; ++i) {
            d += this.geometries[i].getLength();
        }
        return d;
    }

    @Override
    public boolean equalsExact(Geometry geometry, double d) {
        if (!this.isEquivalentClass(geometry)) {
            return false;
        }
        GeometryCollection geometryCollection = (GeometryCollection)geometry;
        if (this.geometries.length != geometryCollection.geometries.length) {
            return false;
        }
        for (int i = 0; i < this.geometries.length; ++i) {
            if (this.geometries[i].equalsExact(geometryCollection.geometries[i], d)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void apply(CoordinateFilter coordinateFilter) {
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].apply(coordinateFilter);
        }
    }

    @Override
    public void apply(CoordinateSequenceFilter coordinateSequenceFilter) {
        if (this.geometries.length == 0) {
            return;
        }
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].apply(coordinateSequenceFilter);
            if (coordinateSequenceFilter.isDone()) break;
        }
        if (coordinateSequenceFilter.isGeometryChanged()) {
            this.geometryChanged();
        }
    }

    @Override
    public void apply(GeometryFilter geometryFilter) {
        geometryFilter.filter(this);
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].apply(geometryFilter);
        }
    }

    @Override
    public void apply(GeometryComponentFilter geometryComponentFilter) {
        geometryComponentFilter.filter(this);
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].apply(geometryComponentFilter);
        }
    }

    @Override
    public Object clone() {
        GeometryCollection geometryCollection = (GeometryCollection)super.clone();
        geometryCollection.geometries = new Geometry[this.geometries.length];
        for (int i = 0; i < this.geometries.length; ++i) {
            geometryCollection.geometries[i] = (Geometry)this.geometries[i].clone();
        }
        return geometryCollection;
    }

    @Override
    public void normalize() {
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].normalize();
        }
        Arrays.sort(this.geometries);
    }

    @Override
    protected Envelope computeEnvelopeInternal() {
        Envelope envelope = new Envelope();
        for (int i = 0; i < this.geometries.length; ++i) {
            envelope.expandToInclude(this.geometries[i].getEnvelopeInternal());
        }
        return envelope;
    }

    @Override
    protected int compareToSameClass(Object object) {
        TreeSet<Geometry> treeSet = new TreeSet<Geometry>(Arrays.asList(this.geometries));
        TreeSet<Geometry> treeSet2 = new TreeSet<Geometry>(Arrays.asList(((GeometryCollection)object).geometries));
        return this.compare(treeSet, treeSet2);
    }

    @Override
    protected int compareToSameClass(Object object, CoordinateSequenceComparator coordinateSequenceComparator) {
        int n;
        GeometryCollection geometryCollection = (GeometryCollection)object;
        int n2 = this.getNumGeometries();
        int n3 = geometryCollection.getNumGeometries();
        for (n = 0; n < n2 && n < n3; ++n) {
            Geometry geometry;
            Geometry geometry2 = this.getGeometryN(n);
            int n4 = geometry2.compareToSameClass(geometry = geometryCollection.getGeometryN(n), coordinateSequenceComparator);
            if (n4 == 0) continue;
            return n4;
        }
        if (n < n2) {
            return 1;
        }
        if (n < n3) {
            return -1;
        }
        return 0;
    }

    @Override
    public Geometry reverse() {
        int n = this.geometries.length;
        Geometry[] geometryArray = new Geometry[n];
        for (int i = 0; i < this.geometries.length; ++i) {
            geometryArray[i] = this.geometries[i].reverse();
        }
        return this.getFactory().createGeometryCollection(geometryArray);
    }
}

