/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.cs;

import java.util.Map;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.Unit;
import org.geotools.measure.Measure;
import org.geotools.referencing.cs.DefaultAffineCS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.resources.i18n.Errors;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystemAxis;

public class DefaultCartesianCS
extends DefaultAffineCS
implements CartesianCS {
    private static final long serialVersionUID = -6182037957705712945L;
    public static DefaultCartesianCS PROJECTED = new DefaultCartesianCS(DefaultCartesianCS.name(177), DefaultCoordinateSystemAxis.EASTING, DefaultCoordinateSystemAxis.NORTHING);
    public static DefaultCartesianCS GEOCENTRIC = new DefaultCartesianCS(DefaultCartesianCS.name(77), DefaultCoordinateSystemAxis.GEOCENTRIC_X, DefaultCoordinateSystemAxis.GEOCENTRIC_Y, DefaultCoordinateSystemAxis.GEOCENTRIC_Z);
    public static DefaultCartesianCS GENERIC_2D = new DefaultCartesianCS(DefaultCartesianCS.name(15), DefaultCoordinateSystemAxis.X, DefaultCoordinateSystemAxis.Y);
    public static DefaultCartesianCS GENERIC_3D = new DefaultCartesianCS(DefaultCartesianCS.name(16), DefaultCoordinateSystemAxis.X, DefaultCoordinateSystemAxis.Y, DefaultCoordinateSystemAxis.Z);
    public static DefaultCartesianCS GRID = new DefaultCartesianCS(DefaultCartesianCS.name(96), DefaultCoordinateSystemAxis.COLUMN, DefaultCoordinateSystemAxis.ROW);
    private transient UnitConverter[] converters;

    public DefaultCartesianCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1) {
        super(properties, axis0, axis1);
        this.ensurePerpendicularAxis();
    }

    public DefaultCartesianCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1, CoordinateSystemAxis axis2) {
        super(properties, axis0, axis1, axis2);
        this.ensurePerpendicularAxis();
    }

    DefaultCartesianCS(Map<String, ?> properties, CoordinateSystemAxis[] axis) {
        super(properties, axis);
        this.ensurePerpendicularAxis();
    }

    private void ensurePerpendicularAxis() throws IllegalArgumentException {
        int dimension = this.getDimension();
        for (int i = 0; i < dimension; ++i) {
            AxisDirection axis0 = this.getAxis(i).getDirection();
            int j = i;
            while (++j < dimension) {
                AxisDirection axis1 = this.getAxis(j).getDirection();
                double angle = DefaultCoordinateSystemAxis.getAngle(axis0, axis1);
                if (!(Math.abs(Math.abs(angle) - 90.0) > 1.0E-10)) continue;
                throw new IllegalArgumentException(Errors.format(115, axis0.name(), axis1.name()));
            }
        }
    }

    @Override
    public Measure distance(double[] coord1, double[] coord2) throws MismatchedDimensionException {
        this.ensureDimensionMatch("coord1", coord1);
        this.ensureDimensionMatch("coord2", coord2);
        Unit<?> unit = this.getDistanceUnit();
        UnitConverter[] converters = this.converters;
        if (converters == null) {
            converters = new UnitConverter[this.getDimension()];
            for (int i = 0; i < converters.length; ++i) {
                converters[i] = this.getAxis(i).getUnit().getConverterTo(unit);
            }
            this.converters = converters;
        }
        double sum = 0.0;
        for (int i = 0; i < converters.length; ++i) {
            UnitConverter c = converters[i];
            double delta = c.convert(coord1[i]) - c.convert(coord2[i]);
            sum += delta * delta;
        }
        return new Measure(Math.sqrt(sum), unit);
    }
}

