/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.index;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.geotools.data.shapefile.shp.IndexFile;
import org.geotools.index.CloseableIterator;
import org.geotools.index.Data;
import org.geotools.index.DataDefinition;
import org.geotools.index.quadtree.Node;
import org.geotools.index.quadtree.QuadTree;
import org.geotools.index.quadtree.StoreException;

public class CachedQuadTree {
    static final DataDefinition DATA_DEFINITION = new DataDefinition("US-ASCII");
    MemoryNode root;
    Indices offsets = new Indices();

    public CachedQuadTree(QuadTree tree) throws IOException {
        this.root = this.cloneAndTranslate(tree.getRoot(), tree.getIndexfile());
    }

    public Envelope getBounds() {
        return new Envelope(this.root.minx, this.root.maxx, this.root.miny, this.root.maxy);
    }

    private MemoryNode cloneAndTranslate(Node node, IndexFile indexfile) throws IOException {
        node.pack();
        int[] shapeIds = node.getShapesId();
        int start = -1;
        int end = -1;
        if (shapeIds != null && shapeIds.length > 0) {
            start = this.offsets.size();
            for (int i = 0; i < shapeIds.length; ++i) {
                this.offsets.add(indexfile.getOffsetInBytes(shapeIds[i]));
            }
            end = this.offsets.size();
        }
        node.clean();
        MemoryNode mem = new MemoryNode(node.getBounds(), start, end, node.getNumSubNodes());
        for (int i = 0; i < node.getNumSubNodes(); ++i) {
            mem.subnodes[i] = this.cloneAndTranslate(node.getSubNode(i), indexfile);
        }
        node.clearSubNodes();
        return mem;
    }

    public CloseableIterator<Data> search(Envelope bounds) throws StoreException {
        final Indices indices = new Indices();
        this.collectIndices(indices, this.root, bounds);
        indices.sort();
        final Data data = new Data(DATA_DEFINITION);
        return new CloseableIterator<Data>(){
            boolean read = true;
            int idx = 0;

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Data next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.read = true;
                return data;
            }

            @Override
            public boolean hasNext() {
                if (!this.read) {
                    return true;
                }
                if (this.idx >= indices.size()) {
                    return false;
                }
                try {
                    data.clear();
                    data.addValue(0);
                    data.addValue(indices.get(this.idx));
                    ++this.idx;
                    this.read = false;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return true;
            }

            @Override
            public void close() throws IOException {
                indices.clear();
            }
        };
    }

    void collectIndices(Indices indices, MemoryNode node, Envelope bounds) throws StoreException {
        if (!node.intersects(bounds)) {
            return;
        }
        if (node.start > -1 && node.end >= node.start) {
            for (int i = node.start; i < node.end; ++i) {
                indices.add(this.offsets.get(i));
            }
        }
        for (MemoryNode child : node.subnodes) {
            this.collectIndices(indices, child, bounds);
        }
    }

    static {
        DATA_DEFINITION.addField(Integer.class);
        DATA_DEFINITION.addField(Long.class);
    }

    static class MemoryNode {
        float minx;
        float miny;
        float maxx;
        float maxy;
        int start;
        int end;
        MemoryNode[] subnodes;

        public MemoryNode(Envelope envelope, int start, int end, int numSubnodes) {
            this.minx = (float)envelope.getMinX();
            this.miny = (float)envelope.getMinY();
            this.maxx = (float)envelope.getMaxX();
            this.maxy = (float)envelope.getMaxY();
            this.start = start;
            this.end = end;
            this.subnodes = new MemoryNode[numSubnodes];
        }

        public boolean intersects(Envelope bounds) {
            return new Envelope(this.minx, this.maxx, this.miny, this.maxy).intersects(bounds);
        }
    }

    class Indices {
        int curr = -1;
        int[] indices = new int[100];

        int size() {
            return this.curr + 1;
        }

        void add(int index) {
            ++this.curr;
            if (this.curr * 2 + 1 >= this.indices.length) {
                int newSize = this.indices.length * 3 / 2;
                if (newSize < 10) {
                    newSize = 10;
                }
                int[] resized = new int[newSize];
                System.arraycopy(this.indices, 0, resized, 0, this.indices.length);
                this.indices = resized;
            }
            this.indices[this.curr] = index;
        }

        void clear() {
            this.curr = -1;
        }

        int get(int position) {
            return this.indices[position];
        }

        void sort() {
            Arrays.sort(this.indices, 0, this.curr + 1);
        }
    }
}

