/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry;

import java.io.Serializable;
import org.geotools.geometry.AbstractDirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.Cloneable;

public class DirectPosition1D
extends AbstractDirectPosition
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3235094562875693710L;
    private CoordinateReferenceSystem crs;
    public double ordinate;

    public DirectPosition1D() {
    }

    public DirectPosition1D(double ordinate) {
        this.ordinate = ordinate;
    }

    @Override
    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    @Override
    public final int getDimension() {
        return 1;
    }

    @Override
    public double[] getCoordinate() {
        return new double[]{this.ordinate};
    }

    @Override
    public final double getOrdinate(int dimension) throws IndexOutOfBoundsException {
        if (dimension == 0) {
            return this.ordinate;
        }
        throw new IndexOutOfBoundsException(String.valueOf(dimension));
    }

    @Override
    public final void setOrdinate(int dimension, double value) throws IndexOutOfBoundsException {
        if (dimension != 0) {
            throw new IndexOutOfBoundsException(String.valueOf(dimension));
        }
        this.ordinate = value;
    }

    @Override
    public int hashCode() {
        long value = Double.doubleToLongBits(this.ordinate);
        int code = 31 + ((int)value ^ (int)(value >>> 32));
        if (this.crs != null) {
            code += this.crs.hashCode();
        }
        assert (code == super.hashCode());
        return code;
    }

    @Override
    public DirectPosition1D clone() {
        try {
            return (DirectPosition1D)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError((Object)exception);
        }
    }
}

