/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.noding.SegmentIntersector;
import com.vividsolutions.jts.noding.SegmentString;

public class SegmentIntersectionDetector
implements SegmentIntersector {
    private LineIntersector li;
    private boolean findProper = false;
    private boolean findAllTypes = false;
    private boolean hasIntersection = false;
    private boolean hasProperIntersection = false;
    private boolean hasNonProperIntersection = false;
    private Coordinate intPt = null;
    private Coordinate[] intSegments = null;

    public SegmentIntersectionDetector(LineIntersector lineIntersector) {
        this.li = lineIntersector;
    }

    public void setFindAllIntersectionTypes(boolean bl) {
        this.findAllTypes = bl;
    }

    public boolean hasIntersection() {
        return this.hasIntersection;
    }

    public boolean hasProperIntersection() {
        return this.hasProperIntersection;
    }

    public boolean hasNonProperIntersection() {
        return this.hasNonProperIntersection;
    }

    @Override
    public void processIntersections(SegmentString segmentString, int n, SegmentString segmentString2, int n2) {
        if (segmentString == segmentString2 && n == n2) {
            return;
        }
        Coordinate coordinate = segmentString.getCoordinates()[n];
        Coordinate coordinate2 = segmentString.getCoordinates()[n + 1];
        Coordinate coordinate3 = segmentString2.getCoordinates()[n2];
        Coordinate coordinate4 = segmentString2.getCoordinates()[n2 + 1];
        this.li.computeIntersection(coordinate, coordinate2, coordinate3, coordinate4);
        if (this.li.hasIntersection()) {
            this.hasIntersection = true;
            boolean bl = this.li.isProper();
            if (bl) {
                this.hasProperIntersection = true;
            }
            if (!bl) {
                this.hasNonProperIntersection = true;
            }
            boolean bl2 = true;
            if (this.findProper && !bl) {
                bl2 = false;
            }
            if (this.intPt == null || bl2) {
                this.intPt = this.li.getIntersection(0);
                this.intSegments = new Coordinate[4];
                this.intSegments[0] = coordinate;
                this.intSegments[1] = coordinate2;
                this.intSegments[2] = coordinate3;
                this.intSegments[3] = coordinate4;
            }
        }
    }

    @Override
    public boolean isDone() {
        if (this.findAllTypes) {
            return this.hasProperIntersection && this.hasNonProperIntersection;
        }
        if (this.findProper) {
            return this.hasProperIntersection;
        }
        return this.hasIntersection;
    }
}

