/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.util;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LinearComponentExtracter
implements GeometryComponentFilter {
    private Collection lines;
    private boolean isForcedToLineString = false;

    public static List getLines(Geometry geometry) {
        return LinearComponentExtracter.getLines(geometry, false);
    }

    public static List getLines(Geometry geometry, boolean bl) {
        ArrayList arrayList = new ArrayList();
        geometry.apply(new LinearComponentExtracter(arrayList, bl));
        return arrayList;
    }

    public LinearComponentExtracter(Collection collection, boolean bl) {
        this.lines = collection;
        this.isForcedToLineString = bl;
    }

    @Override
    public void filter(Geometry geometry) {
        if (this.isForcedToLineString && geometry instanceof LinearRing) {
            LineString lineString = geometry.getFactory().createLineString(((LinearRing)geometry).getCoordinateSequence());
            this.lines.add(lineString);
            return;
        }
        if (geometry instanceof LineString) {
            this.lines.add(geometry);
        }
    }
}

