/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceComparator;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.CoordinateSequences;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.GeometryFilter;
import com.vividsolutions.jts.geom.Lineal;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.operation.BoundaryOp;

public class LineString
extends Geometry
implements Lineal {
    private static final long serialVersionUID = 3110669828065365560L;
    protected CoordinateSequence points;

    public LineString(CoordinateSequence coordinateSequence, GeometryFactory geometryFactory) {
        super(geometryFactory);
        this.init(coordinateSequence);
    }

    private void init(CoordinateSequence coordinateSequence) {
        if (coordinateSequence == null) {
            coordinateSequence = this.getFactory().getCoordinateSequenceFactory().create(new Coordinate[0]);
        }
        if (coordinateSequence.size() == 1) {
            throw new IllegalArgumentException("Invalid number of points in LineString (found " + coordinateSequence.size() + " - must be 0 or >= 2)");
        }
        this.points = coordinateSequence;
    }

    @Override
    public Coordinate[] getCoordinates() {
        return this.points.toCoordinateArray();
    }

    public CoordinateSequence getCoordinateSequence() {
        return this.points;
    }

    public Coordinate getCoordinateN(int n) {
        return this.points.getCoordinate(n);
    }

    @Override
    public Coordinate getCoordinate() {
        if (this.isEmpty()) {
            return null;
        }
        return this.points.getCoordinate(0);
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public int getBoundaryDimension() {
        if (this.isClosed()) {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return this.points.size() == 0;
    }

    @Override
    public int getNumPoints() {
        return this.points.size();
    }

    public Point getPointN(int n) {
        return this.getFactory().createPoint(this.points.getCoordinate(n));
    }

    public Point getStartPoint() {
        if (this.isEmpty()) {
            return null;
        }
        return this.getPointN(0);
    }

    public Point getEndPoint() {
        if (this.isEmpty()) {
            return null;
        }
        return this.getPointN(this.getNumPoints() - 1);
    }

    public boolean isClosed() {
        if (this.isEmpty()) {
            return false;
        }
        return this.getCoordinateN(0).equals2D(this.getCoordinateN(this.getNumPoints() - 1));
    }

    @Override
    public String getGeometryType() {
        return "LineString";
    }

    @Override
    public double getLength() {
        return CGAlgorithms.length(this.points);
    }

    @Override
    public Geometry getBoundary() {
        return new BoundaryOp(this).getBoundary();
    }

    @Override
    public Geometry reverse() {
        CoordinateSequence coordinateSequence = (CoordinateSequence)this.points.clone();
        CoordinateSequences.reverse(coordinateSequence);
        LineString lineString = this.getFactory().createLineString(coordinateSequence);
        return lineString;
    }

    @Override
    protected Envelope computeEnvelopeInternal() {
        if (this.isEmpty()) {
            return new Envelope();
        }
        return this.points.expandEnvelope(new Envelope());
    }

    @Override
    public boolean equalsExact(Geometry geometry, double d) {
        if (!this.isEquivalentClass(geometry)) {
            return false;
        }
        LineString lineString = (LineString)geometry;
        if (this.points.size() != lineString.points.size()) {
            return false;
        }
        for (int i = 0; i < this.points.size(); ++i) {
            if (this.equal(this.points.getCoordinate(i), lineString.points.getCoordinate(i), d)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void apply(CoordinateFilter coordinateFilter) {
        for (int i = 0; i < this.points.size(); ++i) {
            coordinateFilter.filter(this.points.getCoordinate(i));
        }
    }

    @Override
    public void apply(CoordinateSequenceFilter coordinateSequenceFilter) {
        if (this.points.size() == 0) {
            return;
        }
        for (int i = 0; i < this.points.size(); ++i) {
            coordinateSequenceFilter.filter(this.points, i);
            if (coordinateSequenceFilter.isDone()) break;
        }
        if (coordinateSequenceFilter.isGeometryChanged()) {
            this.geometryChanged();
        }
    }

    @Override
    public void apply(GeometryFilter geometryFilter) {
        geometryFilter.filter(this);
    }

    @Override
    public void apply(GeometryComponentFilter geometryComponentFilter) {
        geometryComponentFilter.filter(this);
    }

    @Override
    public Object clone() {
        LineString lineString = (LineString)super.clone();
        lineString.points = (CoordinateSequence)this.points.clone();
        return lineString;
    }

    @Override
    public void normalize() {
        for (int i = 0; i < this.points.size() / 2; ++i) {
            int n = this.points.size() - 1 - i;
            if (this.points.getCoordinate(i).equals(this.points.getCoordinate(n))) continue;
            if (this.points.getCoordinate(i).compareTo(this.points.getCoordinate(n)) > 0) {
                CoordinateArrays.reverse(this.getCoordinates());
            }
            return;
        }
    }

    @Override
    protected boolean isEquivalentClass(Geometry geometry) {
        return geometry instanceof LineString;
    }

    @Override
    protected int compareToSameClass(Object object) {
        int n;
        LineString lineString = (LineString)object;
        int n2 = 0;
        for (n = 0; n2 < this.points.size() && n < lineString.points.size(); ++n2, ++n) {
            int n3 = this.points.getCoordinate(n2).compareTo(lineString.points.getCoordinate(n));
            if (n3 == 0) continue;
            return n3;
        }
        if (n2 < this.points.size()) {
            return 1;
        }
        if (n < lineString.points.size()) {
            return -1;
        }
        return 0;
    }

    @Override
    protected int compareToSameClass(Object object, CoordinateSequenceComparator coordinateSequenceComparator) {
        LineString lineString = (LineString)object;
        return coordinateSequenceComparator.compare(this.points, lineString.points);
    }
}

