/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jts.util.Assert;

public abstract class LineIntersector {
    public static final int NO_INTERSECTION = 0;
    public static final int POINT_INTERSECTION = 1;
    public static final int COLLINEAR_INTERSECTION = 2;
    protected int result;
    protected Coordinate[][] inputLines = new Coordinate[2][2];
    protected Coordinate[] intPt = new Coordinate[2];
    protected boolean isProper;
    protected PrecisionModel precisionModel = null;

    public static double computeEdgeDistance(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        double d = Math.abs(coordinate3.x - coordinate2.x);
        double d2 = Math.abs(coordinate3.y - coordinate2.y);
        double d3 = -1.0;
        if (coordinate.equals(coordinate2)) {
            d3 = 0.0;
        } else if (coordinate.equals(coordinate3)) {
            d3 = d > d2 ? d : d2;
        } else {
            double d4 = Math.abs(coordinate.x - coordinate2.x);
            double d5 = Math.abs(coordinate.y - coordinate2.y);
            d3 = d > d2 ? d4 : d5;
            if (d3 == 0.0 && !coordinate.equals(coordinate2)) {
                d3 = Math.max(d4, d5);
            }
        }
        Assert.isTrue(d3 != 0.0 || coordinate.equals(coordinate2), "Bad distance calculation");
        return d3;
    }

    public LineIntersector() {
        this.intPt[0] = new Coordinate();
        this.intPt[1] = new Coordinate();
        this.result = 0;
    }

    public void setPrecisionModel(PrecisionModel precisionModel) {
        this.precisionModel = precisionModel;
    }

    public abstract void computeIntersection(Coordinate var1, Coordinate var2, Coordinate var3);

    protected boolean isCollinear() {
        return this.result == 2;
    }

    public void computeIntersection(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        this.inputLines[0][0] = coordinate;
        this.inputLines[0][1] = coordinate2;
        this.inputLines[1][0] = coordinate3;
        this.inputLines[1][1] = coordinate4;
        this.result = this.computeIntersect(coordinate, coordinate2, coordinate3, coordinate4);
    }

    protected abstract int computeIntersect(Coordinate var1, Coordinate var2, Coordinate var3, Coordinate var4);

    public String toString() {
        return WKTWriter.toLineString(this.inputLines[0][0], this.inputLines[0][1]) + " - " + WKTWriter.toLineString(this.inputLines[1][0], this.inputLines[1][1]) + this.getTopologySummary();
    }

    private String getTopologySummary() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isEndPoint()) {
            stringBuffer.append(" endpoint");
        }
        if (this.isProper) {
            stringBuffer.append(" proper");
        }
        if (this.isCollinear()) {
            stringBuffer.append(" collinear");
        }
        return stringBuffer.toString();
    }

    protected boolean isEndPoint() {
        return this.hasIntersection() && !this.isProper;
    }

    public boolean hasIntersection() {
        return this.result != 0;
    }

    public int getIntersectionNum() {
        return this.result;
    }

    public Coordinate getIntersection(int n) {
        return this.intPt[n];
    }

    public boolean isIntersection(Coordinate coordinate) {
        for (int i = 0; i < this.result; ++i) {
            if (!this.intPt[i].equals2D(coordinate)) continue;
            return true;
        }
        return false;
    }

    public boolean isInteriorIntersection() {
        if (this.isInteriorIntersection(0)) {
            return true;
        }
        return this.isInteriorIntersection(1);
    }

    public boolean isInteriorIntersection(int n) {
        for (int i = 0; i < this.result; ++i) {
            if (this.intPt[i].equals2D(this.inputLines[n][0]) || this.intPt[i].equals2D(this.inputLines[n][1])) continue;
            return true;
        }
        return false;
    }

    public boolean isProper() {
        return this.hasIntersection() && this.isProper;
    }

    public double getEdgeDistance(int n, int n2) {
        double d = LineIntersector.computeEdgeDistance(this.intPt[n2], this.inputLines[n][0], this.inputLines[n][1]);
        return d;
    }
}

