/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.JunctionChecker.reader;

import java.awt.Color;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import org.openstreetmap.josm.plugins.JunctionChecker.reader.XMLReader;

public class ColorSchemeXMLReader
extends XMLReader {
    private HashMap<String, Color> colorScheme;

    public ColorSchemeXMLReader(String filename) {
        super(filename);
        this.parseXML();
    }

    public Color getColor(String s) {
        if (this.colorScheme.containsKey(s)) {
            return this.colorScheme.get(s);
        }
        return Color.GRAY;
    }

    public void parseXML() {
        this.colorScheme = new HashMap();
        try {
            while (this.parser.hasNext()) {
                switch (this.parser.getEventType()) {
                    case 1: {
                        String tempValue = this.parser.getAttributeValue(null, "color");
                        if (tempValue == null) break;
                        String[] erg = tempValue.split(",");
                        Color c = new Color(Integer.parseInt(erg[0]), Integer.parseInt(erg[1]), Integer.parseInt(erg[2]));
                        this.colorScheme.put(this.parser.getLocalName(), c);
                    }
                }
                this.parser.next();
            }
        }
        catch (XMLStreamException e) {
            System.out.println(e);
        }
    }
}

