/*
 * Decompiled with CFR 0.152.
 */
package utilsplugin2.selection;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import utilsplugin2.selection.NodeWayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MiddleNodesAction
extends JosmAction {
    public static final boolean treeMode = false;
    private Set<Way> activeWays = new HashSet<Way>();

    public MiddleNodesAction() {
        super(I18n.tr((String)"Middle nodes", (Object[])new Object[0]), "midnodes", I18n.tr((String)"Select middle nodes", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:midnodes", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{"Middle nodes"}), (int)69, (int)5007), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/MiddleNodes"));
    }

    public void actionPerformed(ActionEvent e) {
        Collection selection = MiddleNodesAction.getCurrentDataSet().getSelected();
        LinkedHashSet selectedNodes = OsmPrimitive.getFilteredSet((Collection)selection, Node.class);
        LinkedHashSet selectedWays = OsmPrimitive.getFilteredSet((Collection)MiddleNodesAction.getCurrentDataSet().getSelected(), Way.class);
        if (selectedNodes.size() != 2) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select two nodes connected by way!", (Object[])new Object[0]), I18n.tr((String)"Warning", (Object[])new Object[0]), 2);
            return;
        }
        HashSet<Node> newNodes = new HashSet<Node>();
        NodeWayUtils.addMiddle(selectedNodes, newNodes);
        newNodes.removeAll(selectedNodes);
        MiddleNodesAction.getCurrentDataSet().addSelected(newNodes);
        newNodes = null;
    }

    protected void updateEnabledState() {
        if (MiddleNodesAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(MiddleNodesAction.getCurrentDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        if (selection == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(!selection.isEmpty());
    }
}

