/*
 * Decompiled with CFR 0.152.
 */
package utilsplugin2;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnGlueRelationAction
extends JosmAction {
    public UnGlueRelationAction() {
        super(I18n.tr((String)"UnGlue Relation", (Object[])new Object[0]), "ungluerelations", I18n.tr((String)"Duplicate nodes, ways and relations that are used by multiple relations.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:ungluerelation", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"UnGlue Relations", (Object[])new Object[0])}), (int)71, (int)5007), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/UnGlueRelation"));
    }

    public void actionPerformed(ActionEvent e) {
        LinkedList<Object> cmds = new LinkedList<Object>();
        LinkedList<Node> newPrimitives = new LinkedList<Node>();
        Collection selection = UnGlueRelationAction.getCurrentDataSet().getSelected();
        for (OsmPrimitive p : selection) {
            boolean first = true;
            for (Relation relation : OsmPrimitive.getFilteredList((Collection)p.getReferrers(), Relation.class)) {
                if (relation.isDeleted()) continue;
                if (!first) {
                    Node newp;
                    switch (p.getType()) {
                        case NODE: {
                            newp = new Node((Node)p, true);
                            break;
                        }
                        case WAY: {
                            newp = new Way((Way)p, true);
                            break;
                        }
                        case RELATION: {
                            newp = new Relation((Relation)p, true);
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                    newPrimitives.add(newp);
                    cmds.add(new AddCommand((OsmPrimitive)newp));
                    cmds.add(new ChangeCommand((OsmPrimitive)relation, (OsmPrimitive)this.changeRelationMember(relation, p, (OsmPrimitive)newp)));
                    continue;
                }
                first = false;
            }
        }
        if (!newPrimitives.isEmpty()) {
            Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Unglued Relations", (Object[])new Object[0]), cmds));
            newPrimitives.addAll(selection);
            UnGlueRelationAction.getCurrentDataSet().setSelected(newPrimitives);
            Main.map.mapView.repaint();
        }
    }

    private Relation changeRelationMember(Relation relation, OsmPrimitive orginalMember, OsmPrimitive newMember) {
        LinkedList<RelationMember> newrms = new LinkedList<RelationMember>();
        for (RelationMember rm : relation.getMembers()) {
            if (rm.getMember() == orginalMember) {
                newrms.add(new RelationMember(rm.getRole(), newMember));
                continue;
            }
            newrms.add(rm);
        }
        Relation newRelation = new Relation(relation);
        newRelation.setMembers(newrms);
        return newRelation;
    }

    protected void updateEnabledState() {
        if (UnGlueRelationAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(UnGlueRelationAction.getCurrentDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }
}

