/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.generate;

import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.VertexFactory;
import org.jgrapht.generate.GraphGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinearGraphGenerator<V, E>
implements GraphGenerator<V, E, V> {
    public static final String START_VERTEX = "Start Vertex";
    public static final String END_VERTEX = "End Vertex";
    private int size;

    public LinearGraphGenerator(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("must be non-negative");
        }
        this.size = n;
    }

    @Override
    public void generateGraph(Graph<V, E> graph, VertexFactory<V> vertexFactory, Map<String, V> map) {
        Object v = null;
        for (int i = 0; i < this.size; ++i) {
            V v2 = vertexFactory.createVertex();
            graph.addVertex(v2);
            if (v == null) {
                if (map != null) {
                    map.put(START_VERTEX, v2);
                }
            } else {
                graph.addEdge(v, v2);
            }
            v = v2;
        }
        if (map != null && v != null) {
            map.put(END_VERTEX, v);
        }
    }
}

