/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanes.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.turnlanes.CollectionUtils;
import org.openstreetmap.josm.plugins.turnlanes.model.Road;
import org.openstreetmap.josm.plugins.turnlanes.model.Route;
import org.openstreetmap.josm.plugins.turnlanes.model.UnexpectedDataException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final Set<String> ROAD_HIGHWAY_VALUES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("motorway", "motorway_link", "trunk", "trunk_link", "primary", "primary_link", "secondary", "secondary_link", "tertiary", "residential", "unclassified", "road", "living_street", "service", "track", "pedestrian", "raceway", "services")));

    public static boolean isRoad(Way w) {
        return ROAD_HIGHWAY_VALUES.contains(w.get("highway"));
    }

    public static final List<Way> filterRoads(List<OsmPrimitive> of) {
        ArrayList<Way> result = new ArrayList<Way>();
        for (OsmPrimitive p : of) {
            if (p.getType() != OsmPrimitiveType.WAY || !Utils.isRoad((Way)p)) continue;
            result.add((Way)p);
        }
        return result;
    }

    public static Node getMemberNode(Relation r, String role) {
        return Utils.getMember(r, role, OsmPrimitiveType.NODE).getNode();
    }

    public static Way getMemberWay(Relation r, String role) {
        return Utils.getMember(r, role, OsmPrimitiveType.WAY).getWay();
    }

    public static RelationMember getMember(Relation r, String role, OsmPrimitiveType type) {
        List<RelationMember> candidates = Utils.getMembers(r, role, type);
        if (candidates.isEmpty()) {
            throw UnexpectedDataException.Kind.NO_MEMBER.chuck(role);
        }
        if (candidates.size() > 1) {
            throw UnexpectedDataException.Kind.MULTIPLE_MEMBERS.chuck(role);
        }
        return candidates.get(0);
    }

    public static List<RelationMember> getMembers(Relation r, String role, OsmPrimitiveType type) {
        List<RelationMember> result = Utils.getMembers(r, role);
        for (RelationMember m : Utils.getMembers(r, role)) {
            if (m.getType() == type) continue;
            throw UnexpectedDataException.Kind.WRONG_MEMBER_TYPE.chuck(role, m.getType(), type);
        }
        return result;
    }

    public static List<RelationMember> getMembers(Relation r, String role) {
        ArrayList<RelationMember> result = new ArrayList<RelationMember>();
        for (RelationMember m : r.getMembers()) {
            if (!m.getRole().equals(role)) continue;
            result.add(m);
        }
        return result;
    }

    public static List<Node> getMemberNodes(Relation r, String role) {
        return Utils.mapMembers(Utils.getMembers(r, role, OsmPrimitiveType.NODE), Node.class);
    }

    public static List<Way> getMemberWays(Relation r, String role) {
        return Utils.mapMembers(Utils.getMembers(r, role, OsmPrimitiveType.WAY), Way.class);
    }

    private static <T> List<T> mapMembers(List<RelationMember> ms, Class<T> t) {
        ArrayList<T> result = new ArrayList<T>(ms.size());
        for (RelationMember m : ms) {
            result.add(t.cast(m.getMember()));
        }
        return result;
    }

    public static Node lineUp(Way a, Way b) {
        HashSet<Node> s = new HashSet<Node>(Arrays.asList(a.firstNode(), a.lastNode(), b.firstNode(), b.lastNode()));
        if (a.firstNode() == a.lastNode() || b.firstNode().equals((Object)b.lastNode()) || s.size() == 2) {
            throw new IllegalArgumentException("Cycles are not allowed.");
        }
        if (s.size() == 4) {
            throw new IllegalArgumentException("Ways are not connected (at their first and last nodes).");
        }
        if (a.firstNode() == b.firstNode() || a.lastNode() == b.firstNode()) {
            return b.firstNode();
        }
        if (a.firstNode() == b.lastNode() || a.lastNode() == b.lastNode()) {
            return b.lastNode();
        }
        throw new AssertionError();
    }

    public static Node getOppositeEnd(Way w, Node n) {
        boolean first = n.equals((Object)w.firstNode());
        boolean last = n.equals((Object)w.lastNode());
        if (first && last) {
            throw new IllegalArgumentException("Way starts as well as ends at the given node.");
        }
        if (first) {
            return w.lastNode();
        }
        if (last) {
            return w.firstNode();
        }
        throw new IllegalArgumentException("Way neither starts nor ends at given node.");
    }

    public static List<Route> orderWays(Iterable<Way> ways, Iterable<Node> nodes) {
        LinkedList<Way> ws = new LinkedList<Way>(CollectionUtils.toList(ways));
        HashSet<Node> ns = new HashSet<Node>(CollectionUtils.toList(nodes));
        ArrayList<Route> result = new ArrayList<Route>();
        while (!ws.isEmpty()) {
            result.add(Utils.findPath(ws, ns));
        }
        return result;
    }

    private static Route findPath(List<Way> ws, Set<Node> ns) {
        Way next;
        Way w = Utils.findPathSegment(ws, ns);
        boolean first = ns.contains(w.firstNode());
        boolean last = ns.contains(w.lastNode());
        if (first && last) {
            return Route.create(Arrays.asList(w), w.firstNode());
        }
        if (!first && !last) {
            throw new AssertionError();
        }
        ArrayList<Way> result = new ArrayList<Way>();
        result.add(w);
        Node n = first ? w.lastNode() : w.firstNode();
        do {
            next = Utils.findPathSegment(ws, Arrays.asList(n));
            result.add(next);
        } while (!ns.contains(n = Utils.getOppositeEnd(next, n)));
        return Route.create(result, first ? w.firstNode() : w.lastNode());
    }

    private static Way findPathSegment(List<Way> ws, Collection<Node> ns) {
        Iterator<Way> it = ws.iterator();
        while (it.hasNext()) {
            Way w = it.next();
            if (!ns.contains(w.firstNode()) && !ns.contains(w.lastNode())) continue;
            it.remove();
            return w;
        }
        throw new IllegalArgumentException("Ways can't be ordered.");
    }

    public static Iterable<Way> flattenVia(Node start, List<Road> via, Node end) {
        ArrayList<Way> result = new ArrayList<Way>();
        Node n = start;
        for (Road r : via) {
            Iterable<Route.Segment> segments = r.getRoute().getFirstSegment().getWay().isFirstLastNode(n) ? r.getRoute().getSegments() : CollectionUtils.reverse(r.getRoute().getSegments());
            for (Route.Segment s : segments) {
                result.add(s.getWay());
                n = Utils.getOppositeEnd(s.getWay(), n);
            }
        }
        if (!end.equals((Object)n)) {
            throw new IllegalArgumentException("The given via ways don't end at the given node.");
        }
        return result;
    }

    public static int parseIntTag(OsmPrimitive primitive, String tag) {
        String value = primitive.get(tag);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw UnexpectedDataException.Kind.INVALID_TAG_FORMAT.chuck(tag, value);
            }
        }
        throw UnexpectedDataException.Kind.MISSING_TAG.chuck(tag);
    }
}

