/*
 * Decompiled with CFR 0.152.
 */
package net.boplicity.xmleditor;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import net.boplicity.xmleditor.XmlEditorKit;

public class XmlTextPane
extends JTextPane {
    private static final long serialVersionUID = 6270183148379328084L;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public XmlTextPane() {
        this.setEditorKitForContentType("text/xml", new XmlEditorKit());
        this.setContentType("text/xml");
        this.addKeyListener(new IndentKeyListener());
    }

    private class IndentKeyListener
    implements KeyListener {
        private boolean enterFlag;
        private final Character NEW_LINE = Character.valueOf('\n');

        private IndentKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent event) {
            this.enterFlag = false;
            if (event.getKeyCode() == 10 && event.getModifiers() == 0 && XmlTextPane.this.getSelectionStart() == XmlTextPane.this.getSelectionEnd()) {
                this.enterFlag = true;
                event.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent event) {
            if (event.getKeyCode() == 10 && event.getModifiers() == 0 && this.enterFlag) {
                event.consume();
                String text = XmlTextPane.this.getText();
                int caretPosition = XmlTextPane.this.getCaretPosition();
                try {
                    if (text.charAt(caretPosition) == this.NEW_LINE.charValue()) {
                        --caretPosition;
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    // empty catch block
                }
                try {
                    int start;
                    if (text.charAt(start) != this.NEW_LINE.charValue()) {
                        int end;
                        for (end = start = text.lastIndexOf(this.NEW_LINE.charValue(), caretPosition) + 1; end < text.length() && Character.isWhitespace(text.charAt(end)) && text.charAt(end) != this.NEW_LINE.charValue(); ++end) {
                        }
                        if (end > start) {
                            XmlTextPane.this.getDocument().insertString(XmlTextPane.this.getCaretPosition(), this.NEW_LINE + text.substring(start, end), null);
                        } else {
                            XmlTextPane.this.getDocument().insertString(XmlTextPane.this.getCaretPosition(), this.NEW_LINE.toString(), null);
                        }
                    } else {
                        XmlTextPane.this.getDocument().insertString(XmlTextPane.this.getCaretPosition(), this.NEW_LINE.toString(), null);
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    try {
                        XmlTextPane.this.getDocument().insertString(XmlTextPane.this.getCaretPosition(), this.NEW_LINE.toString(), null);
                    }
                    catch (BadLocationException e1) {
                        XmlTextPane.this.logger.log(Level.WARNING, e1.toString());
                    }
                }
                catch (BadLocationException e) {
                    XmlTextPane.this.logger.log(Level.WARNING, e.toString());
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }
}

