/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.canvec_helper;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.plugins.canvec_helper.canvec_helper;

public class CanVecTile {
    canvec_helper plugin_self;
    private ArrayList<String> sub_tile_ids = new ArrayList();
    private boolean zip_scanned = false;
    private ArrayList<CanVecTile> sub_tiles = new ArrayList();
    private boolean sub_tiles_made = false;
    int corda;
    int cordc;
    private boolean valid = false;
    String cordb;
    String cordd;
    private Bounds bounds;
    private String tileid;

    public CanVecTile(String tileid, canvec_helper self) {
        String parta = tileid.substring(0, 3);
        String partb = tileid.substring(3, 4);
        String partc = tileid.substring(4, 6);
        String partd = tileid.substring(6);
        int a = Integer.parseInt(parta);
        int c = Integer.parseInt(partc);
        this.real_init(a, partb, c, partd, self);
    }

    public CanVecTile(int a, String b, int c, String d, canvec_helper self) {
        this.real_init(a, b, c, d, self);
    }

    public void real_init(int a, String b, int c, String d, canvec_helper self) {
        double zero_point_lon;
        double zero_point_lat;
        this.plugin_self = self;
        this.corda = a;
        this.cordb = b;
        this.cordc = c;
        this.cordd = d;
        if (a >= 0 && a <= 119) {
            int column = a / 10;
            int row = a % 10;
            if (row > 6) {
                return;
            }
            zero_point_lat = 40 + 4 * row;
            zero_point_lon = -56 - 8 * column;
            if (row > 6) {
                return;
            }
        } else {
            return;
        }
        double lat_span = 4.0;
        double lon_span = 8.0;
        int grid2 = b == "" ? 0 : b.charAt(0) - 64;
        int[] rows1 = new int[]{0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3};
        int[] cols1 = new int[]{0, 3, 2, 1, 0, 0, 1, 2, 3, 3, 2, 1, 0, 0, 1, 2, 3};
        double lat2 = zero_point_lat + lat_span / 4.0 * (double)rows1[grid2];
        double lon2 = zero_point_lon + lon_span / 4.0 * (double)cols1[grid2];
        if (grid2 != 0) {
            lat_span /= 4.0;
            lon_span /= 4.0;
        }
        int[] rows3 = new int[]{0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3};
        lat2 += lat_span / 4.0 * (double)rows3[c];
        int[] cols3 = new int[]{0, 3, 2, 1, 0, 0, 1, 2, 3, 3, 2, 1, 0, 0, 1, 2, 3};
        lon2 += lon_span / 4.0 * (double)cols3[c];
        if (c != 0) {
            lat_span /= 4.0;
            lon_span /= 4.0;
        }
        if (this.cordd != "") {
            System.out.println("cordd: " + this.cordd);
            String[] foo = this.cordd.split("\\.");
            for (int i = 0; i < foo.length; ++i) {
                int cell;
                System.out.println(foo[i]);
                if (foo[i] == "osm") break;
                if (foo[i] == "") continue;
                try {
                    cell = Integer.parseInt(foo[i]);
                }
                catch (NumberFormatException e) {
                    continue;
                }
                switch (cell) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        lat2 += lat_span / 2.0;
                        break;
                    }
                    case 2: {
                        lat2 += lat_span / 2.0;
                        lon2 += lon_span / 2.0;
                        break;
                    }
                    case 3: {
                        lon2 += lon_span / 2.0;
                    }
                }
                lat_span /= 2.0;
                lon_span /= 2.0;
            }
        }
        this.bounds = new Bounds(lat2, lon2, lat2 + lat_span, lon2 + lon_span);
        this.tileid = this.cordb == "" ? String.format("%03d", this.corda) : (this.cordc == 0 ? String.format("%03d%s", this.corda, this.cordb) : (this.cordd == "" ? String.format("%03d%s%02d", this.corda, this.cordb, this.cordc) : String.format("%03d%s%02d%s", this.corda, this.cordb, this.cordc, this.cordd)));
        this.valid = true;
        System.out.println(this.tileid);
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getTileId() {
        return this.tileid;
    }

    public boolean isVisible(Bounds view) {
        return view.intersects(this.bounds);
    }

    public Point[] getCorners(MapView mv) {
        LatLon min = this.bounds.getMin();
        LatLon max = this.bounds.getMax();
        LatLon x1 = new LatLon(min.lat(), max.lon());
        LatLon x2 = new LatLon(max.lat(), min.lon());
        return new Point[]{mv.getPoint(min), mv.getPoint(x1), mv.getPoint(max), mv.getPoint(x2)};
    }

    public String getDownloadUrl() {
        return String.format("http://ftp2.cits.rncan.gc.ca/osm/pub/%1$03d/%2$s/%1$03d%2$s%3$02d.zip", this.corda, this.cordb, this.cordc);
    }

    private ZipFile open_zip() throws IOException {
        File download_path = new File(this.plugin_self.getPluginDir() + File.separator);
        download_path.mkdir();
        MirroredInputStream tile_zip = new MirroredInputStream(this.getDownloadUrl(), download_path.toString());
        return new ZipFile(tile_zip.getFile());
    }

    public void downloadSelf() {
        ZipFile zipFile;
        if (this.zip_scanned) {
            return;
        }
        try {
            zipFile = this.open_zip();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            this.sub_tile_ids.add(entry.getName());
            this.zip_scanned = true;
            CanVecTile final_tile = new CanVecTile(entry.getName(), this.plugin_self);
            if (!final_tile.isValid()) continue;
            this.sub_tiles.add(final_tile);
        }
    }

    private void load_raw_osm() {
        try {
            ZipFile zipFile = this.open_zip();
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                System.out.println(entry.getName());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        catch (IllegalDataException e) {
            e.printStackTrace();
            return;
        }
    }

    private void make_sub_tiles(int layer) {
        if (this.sub_tiles_made) {
            return;
        }
        switch (layer) {
            case 1: {
                for (int i = 1; i < 17; ++i) {
                    char[] temp = new char[]{(char)(64 + i)};
                    this.sub_tiles.add(new CanVecTile(this.corda, new String(temp), 0, "", this.plugin_self));
                }
                break;
            }
            case 2: {
                for (int i = 1; i < 17; ++i) {
                    this.sub_tiles.add(new CanVecTile(this.corda, this.cordb, i, "", this.plugin_self));
                }
                break;
            }
        }
        this.sub_tiles_made = true;
    }

    public void paint(Graphics2D g, MapView mv, Bounds bounds) {
        boolean show_sub_tiles = false;
        if (!this.isVisible(bounds)) {
            return;
        }
        if (this.cordb != "" && this.cordc > 0 && this.cordd == "" && bounds.getArea() < 0.5) {
            this.downloadSelf();
            System.out.println(this.sub_tile_ids.toString());
            show_sub_tiles = true;
        } else if (this.cordc == 0 && bounds.getArea() < 20.0) {
            this.make_sub_tiles(2);
            show_sub_tiles = true;
        } else if (this.cordb == "" && bounds.getArea() < 40.0) {
            this.make_sub_tiles(1);
            show_sub_tiles = true;
        } else {
            Point[] corners = this.getCorners(mv);
            int[] xs = new int[]{corners[0].x, corners[1].x, corners[2].x, corners[3].x};
            int[] ys = new int[]{corners[0].y, corners[1].y, corners[2].y, corners[3].y};
            Polygon shape = new Polygon(xs, ys, 4);
            g.draw(shape);
            g.drawString(this.getTileId(), corners[0].x, corners[0].y);
        }
        if (show_sub_tiles) {
            for (int i = 0; i < this.sub_tiles.size(); ++i) {
                CanVecTile tile = this.sub_tiles.get(i);
                tile.paint(g, mv, bounds);
            }
        }
    }
}

