/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.licensechange;

import java.awt.Graphics2D;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.licensechange.LicenseChangePlugin;
import org.openstreetmap.josm.plugins.licensechange.LicenseProblem;
import org.openstreetmap.josm.plugins.licensechange.Severity;
import org.openstreetmap.josm.plugins.licensechange.util.Bag;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ProblemLayer
extends Layer
implements MapView.LayerChangeListener {
    private LicenseChangePlugin plugin;
    private int updateCount = -1;

    public ProblemLayer(LicenseChangePlugin plugin) {
        super(I18n.tr((String)"Relicensing Problems", (Object[])new Object[0]));
        this.plugin = plugin;
        MapView.addLayerChangeListener((MapView.LayerChangeListener)this);
    }

    public Icon getIcon() {
        return ImageProvider.get((String)"layer", (String)"licensechange");
    }

    public void paint(Graphics2D g, MapView mv, Bounds bounds) {
        this.updateCount = this.plugin.problemDialog.tree.getUpdateCount();
        DefaultMutableTreeNode root = this.plugin.problemDialog.tree.getRoot();
        if (root == null || root.getChildCount() == 0) {
            return;
        }
        for (DefaultMutableTreeNode severity = (DefaultMutableTreeNode)root.getLastChild(); severity != null; severity = severity.getPreviousSibling()) {
            Enumeration<TreeNode> problemMessages = severity.breadthFirstEnumeration();
            while (problemMessages.hasMoreElements()) {
                Object tn = ((DefaultMutableTreeNode)problemMessages.nextElement()).getUserObject();
                if (!(tn instanceof LicenseProblem)) continue;
                ((LicenseProblem)tn).paint(g, mv);
            }
        }
    }

    public String getToolTipText() {
        Bag<Severity, LicenseProblem> problemTree = new Bag<Severity, LicenseProblem>();
        List<LicenseProblem> problems = this.plugin.problemDialog.tree.getErrors();
        for (LicenseProblem e : problems) {
            problemTree.add(e.getSeverity(), e);
        }
        StringBuilder b = new StringBuilder();
        for (Severity s : Severity.values()) {
            if (!problemTree.containsKey((Object)s)) continue;
            b.append(I18n.tr((String)s.toString(), (Object[])new Object[0])).append(": ").append(problemTree.get((Object)s).size()).append("<br>");
        }
        if (b.length() == 0) {
            return "<html>" + I18n.tr((String)"No relicensing problems", (Object[])new Object[0]) + "</html>";
        }
        return "<html>" + I18n.tr((String)"Relicensing problems", (Object[])new Object[0]) + ":<br>" + b + "</html>";
    }

    public void mergeFrom(Layer from) {
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public boolean isChanged() {
        return this.updateCount != this.plugin.problemDialog.tree.getUpdateCount();
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new RenameLayerAction(null, (Layer)this), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction((Layer)this)};
    }

    public void destroy() {
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
    }

    public void layerAdded(Layer newLayer) {
    }

    public void layerRemoved(Layer oldLayer) {
        if (oldLayer instanceof OsmDataLayer && Main.map.mapView.getEditLayer() == null) {
            Main.map.mapView.removeLayer((Layer)this);
        } else if (oldLayer == this) {
            MapView.removeLayerChangeListener((MapView.LayerChangeListener)this);
            LicenseChangePlugin.problemLayer = null;
        }
    }
}

