/*
 * Decompiled with CFR 0.152.
 */
package sk.zdila.josm.plugin.simplify;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplifyAreaAction
extends JosmAction {
    private static final long serialVersionUID = 6854238214548011750L;
    public static double R = 6378135.0;

    public SimplifyAreaAction() {
        super(I18n.tr((String)"Simplify Area", (Object[])new Object[0]), "simplify", I18n.tr((String)"Delete unnecessary nodes from an area.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:simplifyArea", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Simplify Area", (Object[])new Object[0])}), (int)89, (int)5009), true, "simplifyarea", true);
    }

    private List<Bounds> getCurrentEditBounds() {
        LinkedList<Bounds> bounds = new LinkedList<Bounds>();
        OsmDataLayer dataLayer = Main.map.mapView.getEditLayer();
        for (DataSource ds : dataLayer.data.dataSources) {
            if (ds.bounds == null) continue;
            bounds.add(ds.bounds);
        }
        return bounds;
    }

    private boolean isInBounds(Node node, List<Bounds> bounds) {
        for (Bounds b : bounds) {
            if (!b.contains(node.getCoor())) continue;
            return true;
        }
        return false;
    }

    private boolean confirmWayWithNodesOutsideBoundingBox() {
        HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr((String)"Yes, delete nodes", (Object[])new Object[0]), (Icon)ImageProvider.get((String)"ok"), I18n.tr((String)"Delete nodes outside of downloaded data regions", (Object[])new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr((String)"No, abort", (Object[])new Object[0]), (Icon)ImageProvider.get((String)"cancel"), I18n.tr((String)"Cancel operation", (Object[])new Object[0]), null)};
        int ret = HelpAwareOptionPane.showOptionDialog((Component)Main.parent, (Object)("<html>" + I18n.trn((String)"The selected way has nodes outside of the downloaded data region.", (String)"The selected ways have nodes outside of the downloaded data region.", (long)SimplifyAreaAction.getCurrentDataSet().getSelectedWays().size(), (Object[])new Object[0]) + "<br>" + I18n.tr((String)"This can lead to nodes being deleted accidentally.", (Object[])new Object[0]) + "<br>" + I18n.tr((String)"Do you want to delete them anyway?", (Object[])new Object[0]) + "</html>"), (String)I18n.tr((String)"Delete nodes outside of data regions?", (Object[])new Object[0]), (int)2, null, (HelpAwareOptionPane.ButtonSpec[])options, (HelpAwareOptionPane.ButtonSpec)options[0], null);
        return ret == 0;
    }

    private void alertSelectAtLeastOneWay() {
        HelpAwareOptionPane.showOptionDialog((Component)Main.parent, (Object)I18n.tr((String)"Please select at least one way to simplify.", (Object[])new Object[0]), (String)I18n.tr((String)"Warning", (Object[])new Object[0]), (int)2, null);
    }

    private boolean confirmSimplifyManyWays(int numWays) {
        HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr((String)"Yes", (Object[])new Object[0]), (Icon)ImageProvider.get((String)"ok"), I18n.tr((String)"Simplify all selected ways", (Object[])new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr((String)"Cancel", (Object[])new Object[0]), (Icon)ImageProvider.get((String)"cancel"), I18n.tr((String)"Cancel operation", (Object[])new Object[0]), null)};
        int ret = HelpAwareOptionPane.showOptionDialog((Component)Main.parent, (Object)I18n.tr((String)"The selection contains {0} ways. Are you sure you want to simplify them all?", (Object[])new Object[]{numWays}), (String)I18n.tr((String)"Simplify ways?", (Object[])new Object[0]), (int)2, null, (HelpAwareOptionPane.ButtonSpec[])options, (HelpAwareOptionPane.ButtonSpec)options[0], null);
        return ret == 0;
    }

    public void actionPerformed(ActionEvent e) {
        Collection<Command> avgCommands;
        Collection selection = SimplifyAreaAction.getCurrentDataSet().getSelected();
        List<Bounds> bounds = this.getCurrentEditBounds();
        block0: for (OsmPrimitive prim : selection) {
            if (!(prim instanceof Way) || bounds.size() <= 0) continue;
            Way way = (Way)prim;
            for (Node node : way.getNodes()) {
                if (this.isInBounds(node, bounds)) continue;
                if (this.confirmWayWithNodesOutsideBoundingBox()) continue block0;
                return;
            }
        }
        LinkedHashSet ways = OsmPrimitive.getFilteredSet((Collection)selection, Way.class);
        if (ways.isEmpty()) {
            this.alertSelectAtLeastOneWay();
            return;
        }
        if (ways.size() > 10 && !this.confirmSimplifyManyWays(ways.size())) {
            return;
        }
        ArrayList<Node> nodesToDelete = new ArrayList<Node>();
        for (Way way : ways) {
            this.addNodesToDelete(nodesToDelete, way);
        }
        class Count {
            int count;

            Count() {
            }
        }
        HashMap<Node, Count> nodeCountMap = new HashMap<Node, Count>();
        for (Node node : nodesToDelete) {
            Count count = (Count)nodeCountMap.get(node);
            if (count == null) {
                count = new Count();
                nodeCountMap.put(node, count);
            }
            ++count.count;
        }
        ArrayList<Node> nodesReallyToRemove = new ArrayList<Node>();
        for (Map.Entry entry : nodeCountMap.entrySet()) {
            Node node = (Node)entry.getKey();
            int count = ((Count)entry.getValue()).count;
            if (node.isTagged() || node.getReferrers().size() != count) continue;
            nodesReallyToRemove.add(node);
        }
        ArrayList<Object> allCommands = new ArrayList<Object>();
        if (!nodesReallyToRemove.isEmpty()) {
            for (Way way : ways) {
                List nodes = way.getNodes();
                boolean closed = ((Node)nodes.get(0)).equals(nodes.get(nodes.size() - 1));
                if (closed) {
                    nodes.remove(nodes.size() - 1);
                }
                if (!nodes.removeAll(nodesReallyToRemove)) continue;
                if (closed) {
                    nodes.add(nodes.get(0));
                }
                Way newWay = new Way(way);
                newWay.setNodes(nodes);
                allCommands.add(new ChangeCommand((OsmPrimitive)way, (OsmPrimitive)newWay));
            }
            allCommands.add(new DeleteCommand(nodesReallyToRemove));
        }
        if ((avgCommands = this.averageNearbyNodes(ways, nodesReallyToRemove)) != null) {
            allCommands.add(new SequenceCommand("average nearby nodes", avgCommands));
        }
        if (!allCommands.isEmpty()) {
            SequenceCommand rootCommand = new SequenceCommand(I18n.trn((String)"Simplify {0} way", (String)"Simplify {0} ways", (long)allCommands.size(), (Object[])new Object[]{allCommands.size()}), allCommands);
            Main.main.undoRedo.add((Command)rootCommand);
            Main.map.repaint();
        }
    }

    private Collection<Command> averageNearbyNodes(Collection<Way> ways, Collection<Node> nodesAlreadyDeleted) {
        double mergeThreshold = Main.pref.getDouble("simplify-area.merge.threshold", 0.2);
        HashMap<Node, LatLon> coordMap = new HashMap<Node, LatLon>();
        for (Way way : ways) {
            for (Node node : way.getNodes()) {
                coordMap.put(node, node.getCoor());
            }
        }
        coordMap.keySet().removeAll(nodesAlreadyDeleted);
        block2: for (Way w : ways) {
            List nodes = w.getNodes();
            Node node = (Node)nodes.get(nodes.size() - 1);
            boolean closed = ((Node)nodes.get(0)).equals((Object)node);
            if (closed) {
                nodes.remove(node);
            }
            nodes.retainAll(coordMap.keySet());
            while (true) {
                double minDist = Double.MAX_VALUE;
                Node node1 = null;
                Node node2 = null;
                int len = nodes.size();
                if (len == 0) continue block2;
                for (int i = 0; i <= len; ++i) {
                    double dist;
                    List referrers2;
                    List referrers;
                    Node n1 = (Node)nodes.get(i % len);
                    Node n2 = (Node)nodes.get((i + 1) % len);
                    if (n1.isTagged() || n2.isTagged() || !ways.containsAll(referrers = n1.getReferrers()) || !ways.containsAll(referrers2 = n2.getReferrers()) || !referrers.containsAll(referrers2) || !referrers2.containsAll(referrers) || !((dist = ((LatLon)coordMap.get(n1)).greatCircleDistance((LatLon)coordMap.get(n2))) < minDist) || !(dist < mergeThreshold)) continue;
                    minDist = dist;
                    node1 = n1;
                    node2 = n2;
                }
                if (node1 == null || node2 == null) continue block2;
                LatLon coord = ((LatLon)coordMap.get(node1)).getCenter((LatLon)coordMap.get(node2));
                coordMap.put(node1, coord);
                nodes.remove(node2);
                coordMap.remove(node2);
            }
        }
        ArrayList<Command> commands = new ArrayList<Command>();
        HashSet nodesToDelete2 = new HashSet();
        for (Way way : ways) {
            List nodesToDelete = way.getNodes();
            nodesToDelete.removeAll(nodesAlreadyDeleted);
            if (!nodesToDelete.removeAll(coordMap.keySet())) continue;
            nodesToDelete2.addAll(nodesToDelete);
            Way newWay = new Way(way);
            List nodes = way.getNodes();
            boolean closed = ((Node)nodes.get(0)).equals(nodes.get(nodes.size() - 1));
            if (closed) {
                nodes.remove(nodes.size() - 1);
            }
            nodes.retainAll(coordMap.keySet());
            if (closed) {
                nodes.add(nodes.get(0));
            }
            newWay.setNodes(nodes);
            commands.add((Command)new ChangeCommand((OsmPrimitive)way, (OsmPrimitive)newWay));
        }
        if (!nodesToDelete2.isEmpty()) {
            commands.add((Command)new DeleteCommand(nodesToDelete2));
        }
        for (Map.Entry entry : coordMap.entrySet()) {
            Node node = (Node)entry.getKey();
            LatLon coord = (LatLon)entry.getValue();
            if (node.getCoor().equals((Object)coord)) continue;
            commands.add((Command)new MoveCommand(node, coord));
        }
        return commands;
    }

    private void addNodesToDelete(Collection<Node> nodesToDelete, Way w) {
        double angleThreshold = Main.pref.getDouble("simplify-area.angle.threshold", 10.0);
        double angleFactor = Main.pref.getDouble("simplify-area.angle.factor", 1.0);
        double areaThreshold = Main.pref.getDouble("simplify-area.area.threshold", 5.0);
        double areaFactor = Main.pref.getDouble("simplify-area.area.factor", 1.0);
        double distanceThreshold = Main.pref.getDouble("simplify-area.dist.threshold", 3.0);
        double distanceFactor = Main.pref.getDouble("simplify-area.dist.factor", 3.0);
        List nodes = w.getNodes();
        int size = nodes.size();
        if (size == 0) {
            return;
        }
        boolean closed = ((Node)nodes.get(0)).equals(nodes.get(size - 1));
        if (closed) {
            nodes.remove(size - 1);
        }
        ArrayList<Double> weightList = new ArrayList<Double>(nodes.size());
        for (int i = 0; i < nodes.size(); ++i) {
            weightList.add(null);
        }
        while (true) {
            Node prevNode = null;
            LatLon coord1 = null;
            LatLon coord2 = null;
            int prevIndex = -1;
            double minWeight = Double.MAX_VALUE;
            Node bestMatch = null;
            int size2 = nodes.size();
            if (size2 == 0) break;
            int len = size2 + (closed ? 2 : 1);
            for (int i = 0; i < len; ++i) {
                int index = i % size2;
                Node n = (Node)nodes.get(index);
                LatLon coord3 = n.getCoor();
                if (coord1 != null) {
                    double weight;
                    if (weightList.get(prevIndex) == null) {
                        double angleWeight = SimplifyAreaAction.computeConvectAngle(coord1, coord2, coord3) / angleThreshold;
                        double areaWeight = SimplifyAreaAction.computeArea(coord1, coord2, coord3) / areaThreshold;
                        double distanceWeight = Math.abs(SimplifyAreaAction.crossTrackError(coord1, coord2, coord3)) / distanceThreshold;
                        weight = !closed && i == len - 1 || angleWeight > 1.0 || areaWeight > 1.0 || distanceWeight > 1.0 ? Double.MAX_VALUE : angleWeight * angleFactor + areaWeight * areaFactor + distanceWeight * distanceFactor;
                        weightList.set(prevIndex, weight);
                    } else {
                        weight = (Double)weightList.get(prevIndex);
                    }
                    if (weight < minWeight) {
                        minWeight = weight;
                        bestMatch = prevNode;
                    }
                }
                coord1 = coord2;
                coord2 = coord3;
                prevNode = n;
                prevIndex = index;
            }
            if (bestMatch == null) break;
            int index = nodes.indexOf(bestMatch);
            weightList.set((index - 1 + size2) % size2, null);
            weightList.set((index + 1 + size2) % size2, null);
            weightList.remove(index);
            nodes.remove(index);
        }
        HashSet delNodes = new HashSet(w.getNodes());
        delNodes.removeAll(nodes);
        nodesToDelete.addAll(delNodes);
    }

    public static double computeConvectAngle(LatLon coord1, LatLon coord2, LatLon coord3) {
        double angle = Math.abs(SimplifyAreaAction.heading(coord2, coord3) - SimplifyAreaAction.heading(coord1, coord2));
        return Math.toDegrees(angle < Math.PI ? angle : Math.PI * 2 - angle);
    }

    public static double computeArea(LatLon coord1, LatLon coord2, LatLon coord3) {
        double c;
        double b;
        double a = coord1.greatCircleDistance(coord2);
        double p = (a + (b = coord2.greatCircleDistance(coord3)) + (c = coord3.greatCircleDistance(coord1))) / 2.0;
        double q = p * (p - a) * (p - b) * (p - c);
        return q < 0.0 ? 0.0 : Math.sqrt(q);
    }

    public static double crossTrackError(LatLon l1, LatLon l2, LatLon l3) {
        return R * Math.asin(Math.sin(l1.greatCircleDistance(l2) / R) * Math.sin(SimplifyAreaAction.heading(l1, l2) - SimplifyAreaAction.heading(l1, l3)));
    }

    public static double heading(LatLon a, LatLon b) {
        double hd = Math.atan2(Math.sin(Math.toRadians(a.lon() - b.lon())) * Math.cos(Math.toRadians(b.lat())), Math.cos(Math.toRadians(a.lat())) * Math.sin(Math.toRadians(b.lat())) - Math.sin(Math.toRadians(a.lat())) * Math.cos(Math.toRadians(b.lat())) * Math.cos(Math.toRadians(a.lon() - b.lon())));
        if ((hd %= Math.PI * 2) < 0.0) {
            hd += Math.PI * 2;
        }
        return hd;
    }

    protected void updateEnabledState() {
        if (SimplifyAreaAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(SimplifyAreaAction.getCurrentDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }
}

