/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.ImportImagePlugin;

import java.awt.event.ActionEvent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.ImportImagePlugin.ImageLayer;
import org.openstreetmap.josm.tools.I18n;

public class LoadImageAction
extends JosmAction {
    private Logger logger = Logger.getLogger(LoadImageAction.class);

    public LoadImageAction() {
        super(I18n.tr((String)"Import image", (Object[])new Object[0]), null, I18n.tr((String)"Import georeferenced image", (Object[])new Object[0]), null, false, "importimage/loadimage", true);
    }

    public void actionPerformed(ActionEvent arg0) {
        JFileChooser fc = new JFileChooser(Main.pref.get("plugins.importimage.importpath", null));
        fc.setAcceptAllFileFilterUsed(false);
        int result = fc.showOpenDialog(Main.parent);
        ImageLayer layer = null;
        if (result == 0) {
            Main.pref.put("plugins.importimage.importpath", fc.getCurrentDirectory().getAbsolutePath());
            this.logger.info("File choosen:" + fc.getSelectedFile());
            try {
                layer = new ImageLayer(fc.getSelectedFile());
            }
            catch (ImageLayer.LayerCreationCancledException e) {
                return;
            }
            catch (Exception e) {
                this.logger.error("Error while creating image layer: \n" + e.getMessage());
                JOptionPane.showMessageDialog(null, I18n.marktr((String)("Error while creating image layer: " + e.getCause())));
                return;
            }
            Main.main.addLayer((Layer)layer);
            BoundingXYVisitor boundingXYVisitor = new BoundingXYVisitor();
            layer.visitBoundingBox(boundingXYVisitor);
            Main.map.mapView.recalculateCenterScale(boundingXYVisitor);
        }
    }
}

