/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.datum.Ellipsoid;
import org.osgeo.proj4j.proj.CylindricalProjection;
import org.osgeo.proj4j.util.ProjectionMath;

public class TransverseMercatorProjection
extends CylindricalProjection {
    private static final double FC1 = 1.0;
    private static final double FC2 = 0.5;
    private static final double FC3 = 0.16666666666666666;
    private static final double FC4 = 0.08333333333333333;
    private static final double FC5 = 0.05;
    private static final double FC6 = 0.03333333333333333;
    private static final double FC7 = 0.023809523809523808;
    private static final double FC8 = 0.017857142857142856;
    private int utmZone = -1;
    private double esp;
    private double ml0;
    private double[] en;

    public TransverseMercatorProjection() {
        this.ellipsoid = Ellipsoid.GRS80;
        this.projectionLatitude = Math.toRadians(0.0);
        this.projectionLongitude = Math.toRadians(0.0);
        this.minLongitude = Math.toRadians(-90.0);
        this.maxLongitude = Math.toRadians(90.0);
        this.initialize();
    }

    public TransverseMercatorProjection(Ellipsoid ellipsoid, double lon_0, double lat_0, double k, double x_0, double y_0) {
        this.setEllipsoid(ellipsoid);
        this.projectionLongitude = lon_0;
        this.projectionLatitude = lat_0;
        this.scaleFactor = k;
        this.falseEasting = x_0;
        this.falseNorthing = y_0;
        this.initialize();
    }

    public Object clone() {
        TransverseMercatorProjection p = (TransverseMercatorProjection)super.clone();
        if (this.en != null) {
            p.en = (double[])this.en.clone();
        }
        return p;
    }

    public boolean isRectilinear() {
        return false;
    }

    public void initialize() {
        super.initialize();
        if (this.spherical) {
            this.esp = this.scaleFactor;
            this.ml0 = 0.5 * this.esp;
        } else {
            this.en = ProjectionMath.enfn(this.es);
            this.ml0 = ProjectionMath.mlfn(this.projectionLatitude, Math.sin(this.projectionLatitude), Math.cos(this.projectionLatitude), this.en);
            this.esp = this.es / (1.0 - this.es);
        }
    }

    public int getRowFromNearestParallel(double latitude) {
        int degrees = (int)ProjectionMath.radToDeg(ProjectionMath.normalizeLatitude(latitude));
        if (degrees < -80 || degrees > 84) {
            return 0;
        }
        if (degrees > 80) {
            return 24;
        }
        return (degrees + 80) / 8 + 3;
    }

    public int getZoneFromNearestMeridian(double longitude) {
        int zone = (int)Math.floor((ProjectionMath.normalizeLongitude(longitude) + Math.PI) * 30.0 / Math.PI) + 1;
        if (zone < 1) {
            zone = 1;
        } else if (zone > 60) {
            zone = 60;
        }
        return zone;
    }

    public void setUTMZone(int zone) {
        this.utmZone = zone--;
        this.projectionLongitude = ((double)zone + 0.5) * Math.PI / 30.0 - Math.PI;
        this.projectionLatitude = 0.0;
        this.scaleFactor = 0.9996;
        this.falseEasting = 500000.0;
        this.falseNorthing = this.isSouth ? 1.0E7 : 0.0;
        this.initialize();
    }

    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate xy) {
        if (this.spherical) {
            double cosphi = Math.cos(lpphi);
            double b = cosphi * Math.sin(lplam);
            xy.x = this.ml0 * this.scaleFactor * Math.log((1.0 + b) / (1.0 - b));
            double ty = cosphi * Math.cos(lplam) / Math.sqrt(1.0 - b * b);
            ty = ProjectionMath.acos(ty);
            if (lpphi < 0.0) {
                ty = -ty;
            }
            xy.y = this.esp * (ty - this.projectionLatitude);
        } else {
            double sinphi = Math.sin(lpphi);
            double cosphi = Math.cos(lpphi);
            double t = Math.abs(cosphi) > 1.0E-10 ? sinphi / cosphi : 0.0;
            t *= t;
            double al = cosphi * lplam;
            double als = al * al;
            double n = this.esp * cosphi * cosphi;
            xy.x = this.scaleFactor * (al /= Math.sqrt(1.0 - this.es * sinphi * sinphi)) * (1.0 + 0.16666666666666666 * als * (1.0 - t + n + 0.05 * als * (5.0 + t * (t - 18.0) + n * (14.0 - 58.0 * t) + 0.023809523809523808 * als * (61.0 + t * (t * (179.0 - t) - 479.0)))));
            xy.y = this.scaleFactor * (ProjectionMath.mlfn(lpphi, sinphi, cosphi, this.en) - this.ml0 + sinphi * al * lplam * 0.5 * (1.0 + 0.08333333333333333 * als * (5.0 - t + n * (9.0 + 4.0 * n) + 0.03333333333333333 * als * (61.0 + t * (t - 58.0) + n * (270.0 - 330.0 * t) + 0.017857142857142856 * als * (1385.0 + t * (t * (543.0 - t) - 3111.0))))));
        }
        return xy;
    }

    public ProjCoordinate projectInverse(double x, double y, ProjCoordinate out) {
        if (this.spherical) {
            double h = Math.exp(x / this.scaleFactor);
            double g = 0.5 * (h - 1.0 / h);
            h = Math.cos(this.projectionLatitude + y / this.scaleFactor);
            out.y = ProjectionMath.asin(Math.sqrt((1.0 - h * h) / (1.0 + g * g)));
            if (y < 0.0) {
                out.y = -out.y;
            }
            out.x = Math.atan2(g, h);
        } else {
            out.y = ProjectionMath.inv_mlfn(this.ml0 + y / this.scaleFactor, this.es, this.en);
            if (Math.abs(y) >= 1.5707963267948966) {
                out.y = y < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
                out.x = 0.0;
            } else {
                double sinphi = Math.sin(out.y);
                double cosphi = Math.cos(out.y);
                double t = Math.abs(cosphi) > 1.0E-10 ? sinphi / cosphi : 0.0;
                double n = this.esp * cosphi * cosphi;
                double con = 1.0 - this.es * sinphi * sinphi;
                double d = x * Math.sqrt(con) / this.scaleFactor;
                con *= t;
                t *= t;
                double ds = d * d;
                out.y -= con * ds / (1.0 - this.es) * 0.5 * (1.0 - ds * 0.08333333333333333 * (5.0 + t * (3.0 - 9.0 * n) + n * (1.0 - 4.0 * n) - ds * 0.03333333333333333 * (61.0 + t * (90.0 - 252.0 * n + 45.0 * t) + 46.0 * n - ds * 0.017857142857142856 * (1385.0 + t * (3633.0 + t * (4095.0 + 1574.0 * t))))));
                out.x = d * (1.0 - ds * 0.16666666666666666 * (1.0 + 2.0 * t + n - ds * 0.05 * (5.0 + t * (28.0 + 24.0 * t + 8.0 * n) + 6.0 * n - ds * 0.023809523809523808 * (61.0 + t * (662.0 + t * (1320.0 + 720.0 * t)))))) / cosphi;
            }
        }
        return out;
    }

    public boolean hasInverse() {
        return true;
    }

    public String toString() {
        if (this.utmZone >= 0) {
            return "Universal Tranverse Mercator";
        }
        return "Transverse Mercator";
    }
}

