/*
 * Decompiled with CFR 0.152.
 */
package utilsplugin2.dumbutils;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagSourceAction
extends JosmAction {
    private static final String TITLE = I18n.tr((String)"Add Source Tag", (Object[])new Object[0]);
    private String source;
    private Set<OsmPrimitive> selectionBuf = new HashSet<OsmPrimitive>();
    private boolean clickedTwice = false;

    public TagSourceAction() {
        super(TITLE, "dumbutils/sourcetag", I18n.tr((String)"Add remembered source tag", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:sourcetag", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Add Source Tag", (Object[])new Object[0])}), (int)83, (int)5008), true);
        this.source = Main.pref.get("sourcetag.value");
    }

    public void actionPerformed(ActionEvent e) {
        Collection selection = TagSourceAction.getCurrentDataSet().getSelected();
        if (selection.isEmpty() || this.source == null || this.source.length() == 0) {
            return;
        }
        Main.main.undoRedo.add((Command)new ChangePropertyCommand(selection, "source", this.source));
    }

    protected void updateEnabledState() {
        if (TagSourceAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
            if (this.selectionBuf != null) {
                this.selectionBuf.clear();
            }
        } else {
            this.updateEnabledState(TagSourceAction.getCurrentDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        if (selection == null || selection.isEmpty()) {
            this.selectionBuf.clear();
            this.clickedTwice = false;
            this.setEnabled(false);
            return;
        }
        if (this.selectionBuf.size() == selection.size() && this.selectionBuf.containsAll(selection)) {
            if (!this.clickedTwice) {
                this.clickedTwice = true;
            } else {
                String newSource = null;
                for (OsmPrimitive osmPrimitive : selection) {
                    String value = osmPrimitive.get("source");
                    if (value != null && newSource == null) {
                        newSource = value;
                        continue;
                    }
                    if (!(value != null ? !value.equals(newSource) : newSource != null)) continue;
                    newSource = "";
                    break;
                }
                if (newSource != null && newSource.length() > 0 && !newSource.equals(this.source)) {
                    this.source = newSource;
                    Main.pref.put("sourcetag.value", this.source);
                }
            }
        } else {
            this.clickedTwice = false;
        }
        this.selectionBuf.clear();
        this.selectionBuf.addAll(selection);
        this.setEnabled(this.source != null && this.source.length() > 0);
    }
}

