/*
 * Decompiled with CFR 0.152.
 */
package terracer;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;
import terracer.HouseNumberInputHandler;
import terracer.TerracerRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TerracerAction
extends JosmAction {
    Collection<Command> commands;

    public TerracerAction() {
        super(I18n.tr((String)"Terrace a building", (Object[])new Object[0]), "terrace", I18n.tr((String)"Creates individual buildings from a long building.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:Terracer", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Terrace a building", (Object[])new Object[0])}), (int)84, (int)5005), true);
    }

    public void actionPerformed(ActionEvent e) {
        class InvalidUserInputException
        extends Exception {
            InvalidUserInputException(String message) {
                super(message);
            }

            InvalidUserInputException() {
            }
        }
        Collection sel = TerracerAction.getCurrentDataSet().getSelected();
        Way outline = null;
        Way street = null;
        String streetname = null;
        ArrayList<Node> housenumbers = new ArrayList<Node>();
        Node init = null;
        try {
            if (sel.size() == 1) {
                OsmPrimitive prim = (OsmPrimitive)sel.iterator().next();
                if (!(prim instanceof Way)) {
                    throw new InvalidUserInputException();
                }
                outline = (Way)prim;
            } else if (sel.size() > 1) {
                List ways = OsmPrimitive.getFilteredList((Collection)sel, Way.class);
                for (Way way : ways) {
                    if (way.hasKey("building")) {
                        if (outline != null) {
                            throw new InvalidUserInputException();
                        }
                        outline = way;
                        continue;
                    }
                    if (way.hasKey("highway")) {
                        if (street != null) {
                            throw new InvalidUserInputException();
                        }
                        street = way;
                        streetname = street.get("name");
                        if (streetname != null) continue;
                        throw new InvalidUserInputException();
                    }
                    throw new InvalidUserInputException();
                }
                if (outline == null) {
                    throw new InvalidUserInputException();
                }
                List nodes = OsmPrimitive.getFilteredList((Collection)sel, Node.class);
                for (Node node : nodes) {
                    if (node.hasKey("addr:housenumber")) {
                        String nodesstreetname = node.get("addr:street");
                        if (nodesstreetname != null) {
                            if (streetname == null) {
                                streetname = nodesstreetname;
                            } else if (!nodesstreetname.equals(streetname)) {
                                throw new InvalidUserInputException();
                            }
                        }
                        housenumbers.add(node);
                        continue;
                    }
                    if (!outline.containsNode(node) || init != null) {
                        throw new InvalidUserInputException();
                    }
                    init = node;
                }
                Collections.sort(housenumbers, new HousenumberNodeComparator());
            }
            if (outline == null || !outline.isClosed() || outline.getNodesCount() < 5) {
                throw new InvalidUserInputException();
            }
        }
        catch (InvalidUserInputException ex) {
            new ExtendedDialog(Main.parent, I18n.tr((String)"Invalid selection", (Object[])new Object[0]), new String[]{"OK"}).setButtonIcons(new String[]{"ok"}).setIcon(1).setContent(I18n.tr((String)"Select a single, closed way of at least four nodes. (Optionally you can also select a street for the addr:street tag and a node to mark the start of numbering.)", (Object[])new Object[0])).showDialog();
            return;
        }
        Relation associatedStreet = null;
        if (street != null) {
            block4: for (OsmPrimitive osm : Main.main.getCurrentDataSet().allNonDeletedPrimitives()) {
                Relation rel;
                if (!(osm instanceof Relation) || !"associatedStreet".equals((rel = (Relation)osm).get("type")) || !street.get("name").equals(rel.get("name"))) continue;
                List members = rel.getMembers();
                for (RelationMember m : members) {
                    if (!"street".equals(m.getRole()) || !m.isWay() || !m.getMember().equals((Object)street)) continue;
                    associatedStreet = rel;
                    break block4;
                }
            }
        }
        if (housenumbers.size() == 1) {
            LinkedList<Object> commands = new LinkedList<Object>();
            Way newOutline = new Way(outline);
            for (Map.Entry entry : ((Node)housenumbers.get(0)).getKeys().entrySet()) {
                newOutline.put((String)entry.getKey(), (String)entry.getValue());
            }
            newOutline.put("building", "yes");
            commands.add(new ChangeCommand((OsmPrimitive)outline, (OsmPrimitive)newOutline));
            commands.add(DeleteCommand.delete((OsmDataLayer)Main.main.getEditLayer(), housenumbers, (boolean)true, (boolean)true));
            Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Terrace", (Object[])new Object[0]), commands));
            Main.main.getCurrentDataSet().setSelected(new PrimitiveId[]{newOutline});
        } else {
            String title = I18n.trn((String)"Change {0} object", (String)"Change {0} objects", (long)sel.size(), (Object[])new Object[]{sel.size()});
            new HouseNumberInputHandler(this, outline, init, street, streetname, associatedStreet, housenumbers, title);
        }
    }

    public Integer getNumber(String number) {
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void terraceBuilding(Way outline, Node init, Way street, Relation associatedStreet, Integer segments, String From, String To, int step, ArrayList<Node> housenumbers, String streetName, boolean handleRelations, boolean deleteOutline) {
        int nb;
        Integer to = null;
        Integer from = null;
        if (housenumbers.isEmpty()) {
            to = this.getNumber(To);
            from = this.getNumber(From);
            if (to != null && from != null) {
                nb = 1 + (to - from) / step;
            } else {
                if (segments == null) throw new TerracerRuntimeException("Could not determine segments from parameters, this is a bug. Parameters were: segments " + segments + " from " + from + " to " + to + " step " + step);
                nb = segments;
            }
        } else {
            nb = housenumbers.size();
        }
        Pair<Way, Way> interp = this.findFrontAndBack(outline);
        boolean swap = false;
        if (init != null && (((Way)interp.a).lastNode().equals((Object)init) || ((Way)interp.b).lastNode().equals((Object)init))) {
            swap = true;
        }
        double frontLength = this.wayLength((Way)interp.a);
        double backLength = this.wayLength((Way)interp.b);
        Node[][] new_nodes = new Node[2][nb + 1];
        ArrayList<Node> reused_nodes = new ArrayList<Node>();
        this.commands = new LinkedList<Command>();
        LinkedList<Way> ways = new LinkedList<Way>();
        if (nb > 1) {
            int i;
            for (i = 0; i <= nb; ++i) {
                int i_dir = swap ? nb - i : i;
                new_nodes[0][i] = this.interpolateAlong((Way)interp.a, frontLength * (double)i_dir / (double)nb);
                new_nodes[1][i] = this.interpolateAlong((Way)interp.b, backLength * (double)i_dir / (double)nb);
                if (!outline.containsNode(new_nodes[0][i])) {
                    this.commands.add((Command)new AddCommand((OsmPrimitive)new_nodes[0][i]));
                } else {
                    reused_nodes.add(new_nodes[0][i]);
                }
                if (!outline.containsNode(new_nodes[1][i])) {
                    this.commands.add((Command)new AddCommand((OsmPrimitive)new_nodes[1][i]));
                    continue;
                }
                reused_nodes.add(new_nodes[1][i]);
            }
            for (i = 0; i < nb; ++i) {
                Way terr = new Way();
                terr.addNode(new_nodes[0][i]);
                terr.addNode(new_nodes[0][i + 1]);
                terr.addNode(new_nodes[1][i + 1]);
                terr.addNode(new_nodes[1][i]);
                terr.addNode(new_nodes[0][i]);
                TagCollection.from((Tagged)outline).applyTo((Tagged)terr);
                String number = null;
                Set additionalKeys = null;
                if (housenumbers.isEmpty()) {
                    if (from != null) {
                        number = Integer.toString(from + i * step);
                    }
                } else {
                    number = housenumbers.get(i).get("addr:housenumber");
                    additionalKeys = housenumbers.get(i).getKeys().entrySet();
                }
                terr = this.addressBuilding(terr, street, streetName, number, additionalKeys);
                ways.add(terr);
                this.commands.add((Command)new AddCommand((OsmPrimitive)terr));
            }
            if (deleteOutline) {
                List nodes = outline.getNodes();
                ArrayList<Node> nodesToDelete = new ArrayList<Node>();
                for (Node n : nodes) {
                    if (n.hasKeys() || n.getReferrers().size() != 1 || reused_nodes.contains(n)) continue;
                    nodesToDelete.add(n);
                }
                if (nodesToDelete.size() > 0) {
                    this.commands.add(DeleteCommand.delete((OsmDataLayer)Main.main.getEditLayer(), nodesToDelete));
                }
                this.commands.add(DeleteCommand.delete((OsmDataLayer)Main.main.getEditLayer(), Collections.singleton(outline), (boolean)false, (boolean)true));
            }
        } else {
            Way newOutline = this.addressBuilding(outline, street, streetName, From, null);
            ways.add(newOutline);
            this.commands.add((Command)new ChangeCommand((OsmPrimitive)outline, (OsmPrimitive)newOutline));
        }
        if (handleRelations) {
            if (associatedStreet == null) {
                associatedStreet = new Relation();
                associatedStreet.put("type", "associatedStreet");
                if (street != null) {
                    associatedStreet.put("name", street.get("name"));
                    associatedStreet.addMember(new RelationMember("street", (OsmPrimitive)street));
                } else {
                    associatedStreet.put("name", streetName);
                }
                for (Way w : ways) {
                    associatedStreet.addMember(new RelationMember("house", (OsmPrimitive)w));
                }
                this.commands.add((Command)new AddCommand((OsmPrimitive)associatedStreet));
            } else {
                Relation newAssociatedStreet = new Relation(associatedStreet);
                for (Way w : ways) {
                    newAssociatedStreet.addMember(new RelationMember("house", (OsmPrimitive)w));
                }
                this.commands.add((Command)new ChangeCommand((OsmPrimitive)associatedStreet, (OsmPrimitive)newAssociatedStreet));
            }
        }
        if (!housenumbers.isEmpty()) {
            this.commands.add(DeleteCommand.delete((OsmDataLayer)Main.main.getEditLayer(), housenumbers, (boolean)true, (boolean)true));
        }
        Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Terrace", (Object[])new Object[0]), this.commands));
        if (nb > 1) {
            Main.main.getCurrentDataSet().setSelected(ways);
            return;
        } else {
            if (street == null) return;
            Main.main.getCurrentDataSet().setSelected(new PrimitiveId[]{street});
        }
    }

    private Way addressBuilding(Way outline, Way street, String streetName, String number, Set<Map.Entry<String, String>> additionalKeys) {
        Way changedOutline = outline;
        if (number != null) {
            this.commands.add((Command)new ChangePropertyCommand((OsmPrimitive)changedOutline, "addr:housenumber", number));
        }
        if (additionalKeys != null) {
            for (Map.Entry<String, String> entry : additionalKeys) {
                this.commands.add((Command)new ChangePropertyCommand((OsmPrimitive)changedOutline, entry.getKey(), entry.getValue()));
            }
        }
        changedOutline.put("building", "yes");
        if (street != null) {
            this.commands.add((Command)new ChangePropertyCommand((OsmPrimitive)changedOutline, "addr:street", street.get("name")));
        } else if (streetName != null) {
            this.commands.add((Command)new ChangePropertyCommand((OsmPrimitive)changedOutline, "addr:street", streetName));
        }
        return changedOutline;
    }

    private Node interpolateAlong(Way w, double l) {
        List pairs = w.getNodePairs(false);
        for (int i = 0; i < pairs.size(); ++i) {
            Pair p = (Pair)pairs.get(i);
            double seg_length = ((Node)p.a).getCoor().greatCircleDistance(((Node)p.b).getCoor());
            if (l <= seg_length || i == pairs.size() - 1) {
                return this.interpolateNode((Node)p.a, (Node)p.b, l / seg_length);
            }
            l -= seg_length;
        }
        throw new IllegalStateException();
    }

    private double wayLength(Way w) {
        double length = 0.0;
        for (Pair p : w.getNodePairs(false)) {
            length += ((Node)p.a).getCoor().greatCircleDistance(((Node)p.b).getCoor());
        }
        return length;
    }

    private Pair<Way, Way> findFrontAndBack(Way w) {
        int i;
        int side2;
        double[] sideness = this.calculateSideness(w);
        int[] indexes = this.sortedIndexes(sideness);
        int side1 = indexes[0];
        if (this.indexDistance(side1, side2 = indexes[1], indexes.length) < 2) {
            side2 = indexes[2];
        }
        if (this.indexDistance(side1, side2, indexes.length) < 2) {
            side2 = indexes[3];
        }
        if (this.sideLength(w, side1) > this.sideLength(w, side1 + 1) && Math.abs(sideness[side1] - sideness[(side1 + 1) % (w.getNodesCount() - 1)]) < 0.001) {
            side1 = (side1 + 1) % (w.getNodesCount() - 1);
            side2 = (side2 + 1) % (w.getNodesCount() - 1);
        }
        if (side1 > side2) {
            int tmp = side2;
            side2 = side1;
            side1 = tmp;
        }
        Way front = new Way();
        Way back = new Way();
        for (i = side2 + 1; i < w.getNodesCount() - 1; ++i) {
            front.addNode(w.getNode(i));
        }
        for (i = 0; i <= side1; ++i) {
            front.addNode(w.getNode(i));
        }
        for (i = side2; i > side1; --i) {
            back.addNode(w.getNode(i));
        }
        return new Pair((Object)front, (Object)back);
    }

    private int indexDistance(int i1, int i2, int n) {
        return Math.min(this.positiveModulus(i1 - i2, n), this.positiveModulus(i2 - i1, n));
    }

    private int positiveModulus(int a, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        int res = a % n;
        if (res < 0) {
            res += n;
        }
        return res;
    }

    private double sideLength(Way w, int i) {
        Node a = w.getNode(i);
        Node b = w.getNode((i + 1) % (w.getNodesCount() - 1));
        return a.getCoor().greatCircleDistance(b.getCoor());
    }

    private int[] sortedIndexes(double[] a) {
        int length = a.length;
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class SortWithIndex
        implements Comparable<SortWithIndex> {
            public double x;
            public int i;

            public SortWithIndex(double a, int b) {
                this.x = a;
                this.i = b;
            }

            @Override
            public int compareTo(SortWithIndex o) {
                return Double.compare(this.x, o.x);
            }
        }
        ArrayList<SortWithIndex> sortable = new ArrayList<SortWithIndex>(length);
        for (int i = 0; i < length; ++i) {
            sortable.add(new SortWithIndex(a[i], i));
        }
        Collections.sort(sortable);
        int[] indexes = new int[length];
        for (int i = 0; i < length; ++i) {
            indexes[i] = ((SortWithIndex)sortable.get((int)i)).i;
        }
        return indexes;
    }

    private double[] calculateSideness(Way w) {
        int length = w.getNodesCount() - 1;
        double[] sideness = new double[length];
        sideness[0] = this.calculateSideness(w.getNode(length - 1), w.getNode(0), w.getNode(1), w.getNode(2));
        for (int i = 1; i < length - 1; ++i) {
            sideness[i] = this.calculateSideness(w.getNode(i - 1), w.getNode(i), w.getNode(i + 1), w.getNode(i + 2));
        }
        sideness[length - 1] = this.calculateSideness(w.getNode(length - 2), w.getNode(length - 1), w.getNode(length), w.getNode(1));
        return sideness;
    }

    private double calculateSideness(Node a, Node b, Node c, Node d) {
        double ndx = b.getCoor().getX() - a.getCoor().getX();
        double pdx = d.getCoor().getX() - c.getCoor().getX();
        double ndy = b.getCoor().getY() - a.getCoor().getY();
        double pdy = d.getCoor().getY() - c.getCoor().getY();
        return (ndx * pdx + ndy * pdy) / Math.sqrt((ndx * ndx + ndy * ndy) * (pdx * pdx + pdy * pdy));
    }

    private Node interpolateNode(Node a, Node b, double f) {
        Node n = new Node(a.getEastNorth().interpolate(b.getEastNorth(), f));
        if (n.getCoor().equalsEpsilon(a.getCoor())) {
            return a;
        }
        if (n.getCoor().equalsEpsilon(b.getCoor())) {
            return b;
        }
        return n;
    }

    protected void updateEnabledState() {
        this.setEnabled(TerracerAction.getCurrentDataSet() != null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HousenumberNodeComparator
    implements Comparator<Node> {
        private final Pattern pat = Pattern.compile("^(\\d+)\\s*(.*)");

        HousenumberNodeComparator() {
        }

        @Override
        public int compare(Node node1, Node node2) {
            String node1String = node1.get("addr:housenumber");
            String node2String = node2.get("addr:housenumber");
            Matcher mat = this.pat.matcher(node1String);
            if (mat.find()) {
                Integer node1Int = Integer.valueOf(mat.group(1));
                String node1Rest = mat.group(2);
                mat = this.pat.matcher(node2String);
                if (mat.find()) {
                    Integer node2Int = Integer.valueOf(mat.group(1));
                    if (node1Int.equals(node2Int)) {
                        String node2Rest = mat.group(2);
                        return node1Rest.compareTo(node2Rest);
                    }
                    return node1Int.compareTo(node2Int);
                }
            }
            return node1String.compareTo(node2String);
        }
    }
}

