/*
 * Decompiled with CFR 0.152.
 */
package smed.jide.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import smed.jide.swing.CheckBoxList;
import smed.jide.swing.CheckBoxListSelectionModel;
import smed.jide.swing.NullCheckBox;
import smed.jide.swing.NullLabel;

public class CheckBoxListCellRenderer
extends JPanel
implements ListCellRenderer,
Serializable {
    private static final long serialVersionUID = 2003073492549917883L;
    protected JCheckBox _checkBox = new NullCheckBox();
    protected JLabel _label = new NullLabel();
    protected ListCellRenderer _actualListRenderer;

    public CheckBoxListCellRenderer(ListCellRenderer renderer) {
        this.setOpaque(true);
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this._checkBox, "Before");
        this._actualListRenderer = renderer;
    }

    public CheckBoxListCellRenderer() {
        this((ListCellRenderer)null);
    }

    public ListCellRenderer getActualListRenderer() {
        return this._actualListRenderer;
    }

    public void setActualListRenderer(ListCellRenderer actualListRenderer) {
        this._actualListRenderer = actualListRenderer;
    }

    public String getToolTipText(MouseEvent event) {
        if (this._actualListRenderer instanceof JComponent) {
            Point p = event.getPoint();
            p.translate(-this._checkBox.getWidth(), 0);
            MouseEvent newEvent = new MouseEvent((JComponent)((Object)this._actualListRenderer), event.getID(), event.getWhen(), event.getModifiers(), p.x, p.y, event.getClickCount(), event.isPopupTrigger());
            String tip = ((JComponent)((Object)this._actualListRenderer)).getToolTipText(newEvent);
            if (tip != null) {
                return tip;
            }
        }
        return super.getToolTipText(event);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this._checkBox.setPreferredSize(new Dimension(this._checkBox.getPreferredSize().width, 0));
        this.applyComponentOrientation(list.getComponentOrientation());
        if (list instanceof CheckBoxList) {
            CheckBoxListSelectionModel selectionModel = ((CheckBoxList)list).getCheckBoxListSelectionModel();
            if (selectionModel != null) {
                boolean enabled;
                boolean bl = enabled = list.isEnabled() && ((CheckBoxList)list).isCheckBoxEnabled() && ((CheckBoxList)list).isCheckBoxEnabled(index);
                if (!enabled && !isSelected && this.getBackground() != null) {
                    this.setForeground(this.getBackground().darker());
                }
                this._checkBox.setEnabled(enabled);
                this._checkBox.setSelected(selectionModel.isSelectedIndex(index));
            }
        } else {
            throw new IllegalArgumentException("CheckBoxListCellRenderer should only be used for CheckBoxList.");
        }
        Object actualValue = value;
        if (this._actualListRenderer != null) {
            JComponent listCellRendererComponent = (JComponent)this._actualListRenderer.getListCellRendererComponent(list, actualValue, index, isSelected, cellHasFocus);
            if (list instanceof CheckBoxList && !((CheckBoxList)list).isCheckBoxVisible(index)) {
                return listCellRendererComponent;
            }
            Border border = listCellRendererComponent.getBorder();
            this.setBorder(border);
            listCellRendererComponent.setBorder(BorderFactory.createEmptyBorder());
            if (this.getComponentCount() == 2) {
                this.remove(1);
            }
            this.add(listCellRendererComponent);
            this.setBackground(listCellRendererComponent.getBackground());
            this.setForeground(listCellRendererComponent.getForeground());
        } else {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (this.getComponentCount() == 2) {
                this.remove(1);
            }
            this.add(this._label);
            this.customizeDefaultCellRenderer(actualValue);
            this.setFont(list.getFont());
        }
        return this;
    }

    protected void customizeDefaultCellRenderer(Object value) {
        if (value instanceof Icon) {
            this._label.setIcon((Icon)value);
            this._label.setText("");
        } else {
            this._label.setIcon(null);
            this._label.setText(value == null ? "" : value.toString());
        }
    }

    public static class UIResource
    extends CheckBoxListCellRenderer
    implements javax.swing.plaf.UIResource {
        private static final long serialVersionUID = 1L;
    }
}

