/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osb.gui.action;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.osb.OsbPlugin;
import org.openstreetmap.josm.plugins.osb.gui.OsbDialog;
import org.openstreetmap.josm.plugins.osb.gui.action.ActionQueue;
import org.openstreetmap.josm.tools.I18n;

public class ToggleConnectionModeAction
extends AbstractAction {
    private final OsbPlugin plugin;
    private final OsbDialog dialog;
    private final ActionQueue actionQueue;
    public static final String MSG_ONLINE = I18n.tr((String)"Switch to online mode", (Object[])new Object[0]);
    public static final String MSG_OFFLINE = I18n.tr((String)"Switch to offline mode", (Object[])new Object[0]);

    public ToggleConnectionModeAction(OsbDialog osbDialog, OsbPlugin osbPlugin) {
        super(MSG_OFFLINE);
        this.dialog = osbDialog;
        this.plugin = osbPlugin;
        this.actionQueue = osbDialog.getActionQueue();
    }

    public void actionPerformed(ActionEvent e) {
        boolean isOffline = !Main.pref.getBoolean("osb.api.offline");
        this.dialog.setConnectionMode(isOffline);
        Main.pref.put("osb.api.offline", isOffline);
        if (e.getSource() != null && e.getSource() instanceof JToggleButton) {
            JToggleButton button = (JToggleButton)e.getSource();
            if (isOffline) {
                button.setToolTipText(MSG_ONLINE);
                if (Main.pref.getBoolean("osb.button_labels")) {
                    button.setText(MSG_ONLINE);
                }
            } else {
                button.setToolTipText(MSG_OFFLINE);
                if (Main.pref.getBoolean("osb.button_labels")) {
                    button.setText(MSG_OFFLINE);
                }
            }
        }
        if (!isOffline) {
            if (this.actionQueue.getSize() == 0) {
                this.dialog.hideQueuePanel();
                return;
            }
            int result = JOptionPane.showConfirmDialog(Main.parent, I18n.tr((String)"You have unsaved changes in your queue. Do you want to submit them now?", (Object[])new Object[0]), I18n.tr((String)"OpenStreetBugs", (Object[])new Object[0]), 0);
            if (result == 0) {
                try {
                    this.actionQueue.processQueue();
                    this.dialog.hideQueuePanel();
                    if (!Main.pref.getBoolean("osb.api.disabled")) {
                        this.plugin.updateData();
                    }
                }
                catch (Exception e1) {
                    System.err.println("Couldn't process action queue");
                    e1.printStackTrace();
                }
            }
        } else {
            this.dialog.showQueuePanel();
        }
    }
}

