/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.videomapping.video;

import java.awt.Color;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import org.openstreetmap.josm.plugins.videomapping.VideoPositionLayer;
import org.openstreetmap.josm.plugins.videomapping.video.GPSVideo;
import org.openstreetmap.josm.plugins.videomapping.video.VideoPlayer;
import org.openstreetmap.josm.tools.I18n;

public class GPSVideoPlayer
extends VideoPlayer {
    private List<GPSVideo> videos = new LinkedList<GPSVideo>();
    private VideoPositionLayer videoPositionLayer;

    public GPSVideoPlayer(DateFormat videoTimeFormat, VideoPositionLayer videoPositionLayer) throws HeadlessException {
        super(videoTimeFormat);
        this.videoPositionLayer = videoPositionLayer;
        videoPositionLayer.setGPSVideoPlayer(this);
    }

    public GPSVideo addVideo(File Videofile) {
        GPSVideo video = new GPSVideo(super.addVideo(Videofile, Integer.toString(this.videos.size())));
        this.enableSingleVideoMode(true);
        this.videos.add(video);
        this.addSyncButton(video);
        return video;
    }

    private void addSyncButton(GPSVideo video) {
        JButton syncButton = new JButton(I18n.tr((String)"Sync", (Object[])new Object[0]));
        syncButton.setBackground(Color.RED);
        syncButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GPSVideoPlayer.this.resync(e);
            }
        });
        video.SyncComponent = syncButton;
        this.controlsPanel.add(syncButton);
    }

    private void resync(ActionEvent e) {
        JButton btn = (JButton)e.getSource();
        GPSVideo v = this.findVideo(btn);
        v.doSync(this.videoPositionLayer);
        btn.setBackground(Color.GREEN);
        this.enableSingleVideoMode(false);
    }

    protected GPSVideo findVideo(JButton source) {
        for (GPSVideo v : this.videos) {
            if (v.SyncComponent != source) continue;
            return v;
        }
        return null;
    }

    public void jumpTo(Date date) {
        for (GPSVideo video : this.videos) {
            video.jumpTo(date);
        }
    }

    public boolean areAllVideosSynced() {
        for (GPSVideo video : this.videos) {
            if (video.isSynced()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void update_plays() {
        super.update_plays();
        if (this.areAllVideosSynced()) {
            this.videoPositionLayer.setIconPosition(this.videos.get(0).getCurrentWayPoint());
        }
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        this.videoPositionLayer.unload();
        super.windowClosing(arg0);
    }
}

