/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.W32API;
import com.sun.jna.platform.win32.W32Errors;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;

public abstract class Kernel32Util {
    public static String getComputerName() {
        IntByReference lpnSize;
        char[] buffer = new char[WinBase.MAX_COMPUTERNAME_LENGTH() + 1];
        if (!Kernel32.INSTANCE.GetComputerName(buffer, lpnSize = new IntByReference(buffer.length))) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return Native.toString(buffer);
    }

    public static String formatMessageFromHR(W32API.HRESULT code) {
        PointerByReference buffer = new PointerByReference();
        if (0 == Kernel32.INSTANCE.FormatMessage(4864, null, code.intValue(), 0, buffer, 0, null)) {
            throw new LastErrorException(Kernel32.INSTANCE.GetLastError());
        }
        String s = buffer.getValue().getString(0L, !Boolean.getBoolean("w32.ascii"));
        s = s.replace(".\r", ".").replace(".\n", ".");
        Kernel32.INSTANCE.LocalFree(buffer.getValue());
        return s;
    }

    public static String formatMessageFromLastErrorCode(int code) {
        return Kernel32Util.formatMessageFromHR(W32Errors.HRESULT_FROM_WIN32(code));
    }

    public static String getTempPath() {
        W32API.DWORD nBufferLength = new W32API.DWORD(260L);
        char[] buffer = new char[nBufferLength.intValue()];
        if (Kernel32.INSTANCE.GetTempPath(nBufferLength, buffer).intValue() == 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return Native.toString(buffer);
    }
}

