/*
 * Decompiled with CFR 0.152.
 */
package mappaint;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import mappaint.AreaElemStyle;
import mappaint.ElemStyle;
import mappaint.IconElemStyle;
import mappaint.LineElemStyle;
import mappaint.MapPaintPlugin;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Segment;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.SimplePaintVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;

public class MapPaintVisitor
extends SimplePaintVisitor {
    public void visit(Node n) {
        ElemStyle nodeStyle = MapPaintPlugin.elemStyles.getStyle((OsmPrimitive)n);
        if (nodeStyle != null && Main.map.mapView.zoom() >= nodeStyle.getMinZoom()) {
            if (nodeStyle instanceof IconElemStyle) {
                this.drawNode(n, ((IconElemStyle)nodeStyle).getIcon());
            }
        } else {
            this.drawNode(n, n.selected ? MapPaintVisitor.getPreferencesColor((String)"selected", (Color)Color.YELLOW) : MapPaintVisitor.getPreferencesColor((String)"node", (Color)Color.RED));
        }
    }

    public void visit(Segment ls) {
        this.drawSegment(ls, MapPaintVisitor.getPreferencesColor((String)"untagged", (Color)Color.GRAY), Main.pref.getBoolean("draw.segment.direction"));
    }

    public void visit(Way w) {
        double circum = Main.map.mapView.getScale() * 100.0 * Main.proj.scaleFactor() * 4.0041455E7;
        Color colour = MapPaintVisitor.getPreferencesColor((String)"untagged", (Color)Color.GRAY);
        int width = 2;
        int realWidth = 0;
        boolean area = false;
        ElemStyle wayStyle = MapPaintPlugin.elemStyles.getStyle((OsmPrimitive)w);
        if (wayStyle != null) {
            if (wayStyle instanceof LineElemStyle) {
                colour = ((LineElemStyle)wayStyle).getColour();
                width = ((LineElemStyle)wayStyle).getWidth();
                realWidth = ((LineElemStyle)wayStyle).getRealWidth();
            } else if (wayStyle instanceof AreaElemStyle) {
                colour = ((AreaElemStyle)wayStyle).getColour();
                area = true;
            }
        }
        boolean fillAreas = Main.pref.getBoolean("mappaint.fillareas", true);
        if (area && fillAreas) {
            this.drawWayAsArea(w, colour);
        }
        int orderNumber = 0;
        for (Segment ls : w.segments) {
            int tmpWidth;
            ++orderNumber;
            if (area && fillAreas) {
                this.drawSegment(ls, w.selected ? MapPaintVisitor.getPreferencesColor((String)"selected", (Color)Color.YELLOW) : MapPaintVisitor.getPreferencesColor((String)"untagged", (Color)Color.GRAY), Main.pref.getBoolean("draw.segment.direction"), width, true);
            } else if (area) {
                this.drawSegment(ls, w.selected ? MapPaintVisitor.getPreferencesColor((String)"selected", (Color)Color.YELLOW) : colour, Main.pref.getBoolean("draw.segment.direction"), width, true);
            } else if (realWidth > 0 && Main.pref.getBoolean("mappaint.useRealWith", false) && (tmpWidth = (int)(100.0f / (float)(circum / (double)realWidth))) > width) {
                width = tmpWidth;
            }
            this.drawSegment(ls, w.selected ? MapPaintVisitor.getPreferencesColor((String)"selected", (Color)Color.YELLOW) : colour, Main.pref.getBoolean("draw.segment.direction"), width, false);
            if (ls.incomplete || !Main.pref.getBoolean("draw.segment.order_number")) continue;
            try {
                this.g.setColor(w.selected ? MapPaintVisitor.getPreferencesColor((String)"selected", (Color)Color.YELLOW) : colour);
                this.drawOrderNumber(ls, orderNumber);
            }
            catch (IllegalAccessError e) {}
        }
    }

    protected void drawWayAsArea(Way w, Color colour) {
        Polygon polygon = new Polygon();
        boolean first = true;
        for (Segment ls : w.segments) {
            Point p;
            if (ls.incomplete) continue;
            if (first) {
                p = this.nc.getPoint(ls.from.eastNorth);
                polygon.addPoint(p.x, p.y);
                first = false;
            }
            p = this.nc.getPoint(ls.to.eastNorth);
            polygon.addPoint(p.x, p.y);
        }
        this.g.setColor(w.selected ? MapPaintVisitor.getPreferencesColor((String)"selected", (Color)Color.YELLOW) : colour);
        this.g.fillPolygon(polygon);
    }

    protected void drawNode(Node n, ImageIcon icon) {
        String name;
        Point p = this.nc.getPoint(n.eastNorth);
        if (p.x < 0 || p.y < 0 || p.x > this.nc.getWidth() || p.y > this.nc.getHeight()) {
            return;
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        icon.paintIcon((Component)Main.map.mapView, this.g, p.x - w / 2, p.y - h / 2);
        String string = name = n.keys == null ? null : (String)n.keys.get("name");
        if (name != null) {
            this.g.setColor(MapPaintVisitor.getPreferencesColor((String)"text", (Color)Color.WHITE));
            Font defaultFont = this.g.getFont();
            this.g.setFont(new Font("Helvetica", 0, 8));
            this.g.drawString(name, p.x + w / 2 + 2, p.y + h / 2 + 2);
            this.g.setFont(defaultFont);
        }
        if (n.selected) {
            this.g.setColor(MapPaintVisitor.getPreferencesColor((String)"selected", (Color)Color.YELLOW));
            this.g.drawRect(p.x - w / 2 - 2, p.y - w / 2 - 2, w + 4, h + 4);
        }
    }

    protected void drawSegment(Segment ls, Color col, boolean showDirection) {
        this.drawSegment(ls, col, showDirection, 1, false);
    }

    private void drawSegment(Segment ls, Color col, boolean showDirection, int width, boolean dashed) {
        if (ls.shown) {
            return;
        }
        ls.shown = true;
        Graphics2D g2d = (Graphics2D)this.g;
        if (ls.incomplete) {
            return;
        }
        if (ls.selected) {
            col = MapPaintVisitor.getPreferencesColor((String)"selected", (Color)Color.YELLOW);
        }
        this.g.setColor(col);
        if (dashed) {
            g2d.setStroke(new BasicStroke(width, 0, 1, 0.0f, new float[]{9.0f}, 0.0f));
        } else {
            g2d.setStroke(new BasicStroke(width));
        }
        Point p1 = this.nc.getPoint(ls.from.eastNorth);
        Point p2 = this.nc.getPoint(ls.to.eastNorth);
        if (p1.x < 0 && p2.x < 0) {
            return;
        }
        if (p1.y < 0 && p2.y < 0) {
            return;
        }
        if (p1.x > this.nc.getWidth() && p2.x > this.nc.getWidth()) {
            return;
        }
        if (p1.y > this.nc.getHeight() && p2.y > this.nc.getHeight()) {
            return;
        }
        this.g.drawLine(p1.x, p1.y, p2.x, p2.y);
        if (showDirection) {
            double t = Math.atan2(p2.y - p1.y, p2.x - p1.x) + Math.PI;
            this.g.drawLine(p2.x, p2.y, (int)((double)p2.x + 10.0 * Math.cos(t - PHI)), (int)((double)p2.y + 10.0 * Math.sin(t - PHI)));
            this.g.drawLine(p2.x, p2.y, (int)((double)p2.x + 10.0 * Math.cos(t + PHI)), (int)((double)p2.y + 10.0 * Math.sin(t + PHI)));
        }
    }

    public void drawNode(Node n, Color color) {
        Point p = this.nc.getPoint(n.eastNorth);
        if (p.x < 0 || p.y < 0 || p.x > this.nc.getWidth() || p.y > this.nc.getHeight()) {
            return;
        }
        this.g.setColor(color);
        this.g.drawRect(p.x - 1, p.y - 1, 2, 2);
    }

    public void visitAll(DataSet data) {
        LinkedList<Way> noAreaWays = new LinkedList<Way>();
        for (Segment segment : data.segments) {
            if (segment.deleted) continue;
            segment.shown = false;
        }
        for (Way way : data.ways) {
            if (!way.deleted && MapPaintPlugin.elemStyles.isArea((OsmPrimitive)way)) {
                way.visit((Visitor)this);
                continue;
            }
            if (way.deleted) continue;
            noAreaWays.add(way);
        }
        for (Way way : noAreaWays) {
            way.visit((Visitor)this);
        }
        for (Segment segment : data.segments) {
            if (segment.deleted) continue;
            segment.visit((Visitor)this);
        }
        for (Node node : data.nodes) {
            if (node.deleted) continue;
            node.visit((Visitor)this);
        }
        for (OsmPrimitive osmPrimitive : data.getSelected()) {
            if (osmPrimitive.deleted) continue;
            osmPrimitive.shown = false;
            osmPrimitive.visit((Visitor)this);
        }
    }
}

