/*
 * Decompiled with CFR 0.152.
 */
package utilsplugin2.selection;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectWayNodesAction
extends JosmAction {
    private Node selectedNode;
    private ArrayList<Node> selectedNodes;

    public SelectWayNodesAction() {
        super(I18n.tr((String)"Select Way Nodes", (Object[])new Object[0]), "selectwaynodes", I18n.tr((String)"Select all nodes of a selected way.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:selectwaynodes", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Select Way Nodes", (Object[])new Object[0])}), (int)78, (int)5009), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/SelectWayNodes"));
    }

    public void actionPerformed(ActionEvent e) {
        Collection selection = SelectWayNodesAction.getCurrentDataSet().getSelected();
        Object errMsg = null;
        for (OsmPrimitive p : selection) {
            if (p instanceof Way) {
                Way w = (Way)p;
                if (!w.isUsable() || w.getNodesCount() < 1) continue;
                this.selectWayNodes(w);
                continue;
            }
            if (!(p instanceof Node)) continue;
            Node n = (Node)p;
            if (this.selectedNodes == null) {
                this.selectedNodes = new ArrayList();
            }
            this.selectedNodes.add(n);
        }
        SelectWayNodesAction.getCurrentDataSet().setSelected(this.selectedNodes);
        this.selectedNodes = null;
    }

    private void selectWayNodes(Way w) {
        for (Node n : w.getNodes()) {
            if (this.selectedNodes == null) {
                this.selectedNodes = new ArrayList();
            }
            this.selectedNodes.add(n);
        }
    }

    protected void updateEnabledState() {
        if (SelectWayNodesAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(SelectWayNodesAction.getCurrentDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }
}

