/*
 * Decompiled with CFR 0.152.
 */
package utilsplugin2.dumbutils;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagBufferAction
extends JosmAction {
    private static final String TITLE = I18n.tr((String)"Copy tags from previous selection", (Object[])new Object[0]);
    private Map<String, String> tags = new HashMap<String, String>();
    private Map<String, String> currentTags = new HashMap<String, String>();
    private Set<OsmPrimitive> selectionBuf = new HashSet<OsmPrimitive>();

    public TagBufferAction() {
        super(TITLE, "dumbutils/tagbuffer", I18n.tr((String)"Pastes tags of previously selected object(s)", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:tagbuffer", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Copy tags from previous selection", (Object[])new Object[0])}), (int)82, (int)5005), true);
    }

    public void actionPerformed(ActionEvent e) {
        Collection selection = TagBufferAction.getCurrentDataSet().getSelected();
        if (selection.isEmpty()) {
            return;
        }
        ArrayList<ChangePropertyCommand> commands = new ArrayList<ChangePropertyCommand>();
        for (String key : this.tags.keySet()) {
            String value = this.tags.get(key);
            boolean foundNew = false;
            for (OsmPrimitive p : selection) {
                if (p.hasKey(key) && p.get(key).equals(value)) continue;
                foundNew = true;
                break;
            }
            if (!foundNew) continue;
            commands.add(new ChangePropertyCommand(selection, key, value));
        }
        if (!commands.isEmpty()) {
            Main.main.undoRedo.add((Command)new SequenceCommand(TITLE, commands));
        }
    }

    protected void updateEnabledState() {
        if (TagBufferAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
            if (this.selectionBuf != null) {
                this.selectionBuf.clear();
            }
        } else {
            this.updateEnabledState(TagBufferAction.getCurrentDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        boolean foundOld = false;
        if (selection != null) {
            for (OsmPrimitive p : this.selectionBuf) {
                if (!selection.contains(p)) continue;
                foundOld = true;
                break;
            }
            this.selectionBuf.clear();
            this.selectionBuf.addAll(selection);
        } else {
            foundOld = this.selectionBuf.isEmpty();
            this.selectionBuf.clear();
        }
        if (!foundOld) {
            this.tags.clear();
            this.tags.putAll(this.currentTags);
        }
        this.rememberSelectionTags();
        this.setEnabled(selection != null && !selection.isEmpty() && !this.tags.isEmpty());
    }

    private void rememberSelectionTags() {
        if (TagBufferAction.getCurrentDataSet() != null && !TagBufferAction.getCurrentDataSet().getSelected().isEmpty()) {
            this.currentTags.clear();
            HashSet<String> bad = new HashSet<String>();
            for (OsmPrimitive p : TagBufferAction.getCurrentDataSet().getSelected()) {
                if (this.currentTags.isEmpty()) {
                    for (String key : p.keySet()) {
                        this.currentTags.put(key, p.get(key));
                    }
                    continue;
                }
                for (String key : p.keySet()) {
                    if (this.currentTags.containsKey(key) && this.currentTags.get(key).equals(p.get(key))) continue;
                    bad.add(key);
                }
                for (String key : this.currentTags.keySet()) {
                    if (p.hasKey(key)) continue;
                    bad.add(key);
                }
            }
            for (String key : bad) {
                this.currentTags.remove(key);
            }
        }
    }
}

