/*
 * Decompiled with CFR 0.152.
 */
package utilsplugin2.dumbutils;

import java.awt.event.ActionEvent;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeNodesCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.RelationToChildReference;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.conflict.tags.CombinePrimitiveResolverDialog;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolutionUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplaceGeometryAction
extends JosmAction {
    private static final String TITLE = I18n.tr((String)"Replace Geometry", (Object[])new Object[0]);

    public ReplaceGeometryAction() {
        super(TITLE, "dumbutils/replacegeometry", I18n.tr((String)"Replace geometry of selected object with a new one", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:replacegeometry", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Replace Geometry", (Object[])new Object[0])}), (int)71, (int)5009), true);
    }

    public void actionPerformed(ActionEvent e) {
        if (ReplaceGeometryAction.getCurrentDataSet() == null) {
            return;
        }
        ArrayList selection = new ArrayList(ReplaceGeometryAction.getCurrentDataSet().getSelected());
        if (selection.size() != 2) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"This tool replaces geometry of one object with another, and so requires exactly two objects to be selected.", (Object[])new Object[0]), TITLE, 1);
            return;
        }
        OsmPrimitive firstObject = (OsmPrimitive)selection.get(0);
        OsmPrimitive secondObject = (OsmPrimitive)selection.get(1);
        try {
            this.replace(firstObject, secondObject);
        }
        catch (IllegalArgumentException ex) {
            JOptionPane.showMessageDialog(Main.parent, ex.getMessage(), TITLE, 1);
        }
    }

    public void replace(OsmPrimitive firstObject, OsmPrimitive secondObject) {
        if (firstObject instanceof Way && secondObject instanceof Way) {
            this.replaceWayWithWay(Arrays.asList((Way)firstObject, (Way)secondObject));
        } else {
            if (firstObject instanceof Node && secondObject instanceof Node) {
                throw new IllegalArgumentException(I18n.tr((String)"To replace a node with a node, use the node merge tool.", (Object[])new Object[0]));
            }
            if (firstObject instanceof Node) {
                this.replaceNode((Node)firstObject, secondObject);
            } else if (secondObject instanceof Node) {
                this.replaceNode((Node)secondObject, firstObject);
            } else {
                throw new IllegalArgumentException(I18n.tr((String)"This tool can only replace a node with a way, a node with a multipolygon, or a way with a way.", (Object[])new Object[0]));
            }
        }
    }

    public void replaceNode(Node node, OsmPrimitive target) {
        if (!OsmPrimitive.getFilteredList((Collection)node.getReferrers(), Way.class).isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Node belongs to way(s), cannot replace.", (Object[])new Object[0]), TITLE, 1);
            return;
        }
        if (target instanceof Relation && !((Relation)target).isMultipolygon()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Relation is not a multipolygon, cannot be used as a replacement.", (Object[])new Object[0]), TITLE, 1);
            return;
        }
        Node nodeToReplace = null;
        if (!node.isNew()) {
            HashSet<Node> nodePool = new HashSet<Node>();
            if (target instanceof Way) {
                nodePool.addAll(this.getUnimportantNodes((Way)target));
            } else if (target instanceof Relation) {
                for (RelationMember member : ((Relation)target).getMembers()) {
                    if (!member.getRole().equals("outer") && !member.getRole().equals("inner") || !member.isWay()) continue;
                    nodePool.addAll(this.getUnimportantNodes(member.getWay()));
                }
            } else assert (false);
            nodeToReplace = this.findNearestNode(node, nodePool);
        }
        ArrayList<Object> commands = new ArrayList<Object>();
        AbstractMap nodeTags = (AbstractMap)node.getKeys();
        List<Command> tagResolutionCommands = this.getTagConflictResolutionCommands((OsmPrimitive)node, target);
        if (tagResolutionCommands == null) {
            return;
        }
        commands.addAll(tagResolutionCommands);
        if (nodeToReplace != null) {
            Way parentWay = (Way)nodeToReplace.getReferrers().get(0);
            List wayNodes = parentWay.getNodes();
            int idx = wayNodes.indexOf(nodeToReplace);
            wayNodes.set(idx, node);
            if (idx == 0 && parentWay.isClosed()) {
                wayNodes.set(wayNodes.size() - 1, node);
            }
            commands.add(new ChangeNodesCommand(parentWay, wayNodes));
            commands.add(new MoveCommand(node, nodeToReplace.getCoor()));
            commands.add(new DeleteCommand((OsmPrimitive)nodeToReplace));
            if (!nodeTags.isEmpty()) {
                for (String key : nodeTags.keySet()) {
                    commands.add(new ChangePropertyCommand((OsmPrimitive)node, key, null));
                }
            }
        } else {
            commands.add(new DeleteCommand((OsmPrimitive)node));
        }
        ReplaceGeometryAction.getCurrentDataSet().setSelected(new PrimitiveId[]{target});
        Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Replace geometry for node {0}", (Object[])new Object[]{node.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())}), commands));
    }

    public void replaceWayWithWay(List<Way> selection) {
        int idxNew;
        boolean overrideNewCheck = false;
        int n = idxNew = selection.get(0).isNew() ? 0 : 1;
        if (selection.get(1 - idxNew).isNew()) {
            boolean areNewNodes = false;
            for (Node n2 : selection.get(0).getNodes()) {
                if (!n2.isNew()) continue;
                areNewNodes = true;
            }
            idxNew = areNewNodes ? 0 : 1;
            overrideNewCheck = true;
            for (Node n2 : selection.get(1 - idxNew).getNodes()) {
                if (!n2.isNew()) continue;
                overrideNewCheck = false;
            }
        }
        Way geometry = selection.get(idxNew);
        Way way = selection.get(1 - idxNew);
        if (!(overrideNewCheck || !way.isNew() && geometry.isNew())) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select one way that exists in the database and one new way with correct geometry.", (Object[])new Object[0]), TITLE, 2);
            return;
        }
        Area a = ReplaceGeometryAction.getCurrentDataSet().getDataSourceArea();
        if (!ReplaceGeometryAction.isInArea(way, a) || !ReplaceGeometryAction.isInArea(geometry, a)) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"The ways must be entirely within the downloaded area.", (Object[])new Object[0]), TITLE, 2);
            return;
        }
        if (this.hasImportantNode(geometry, way)) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"The way to be replaced cannot have any nodes with properties or relation memberships unless they belong to both ways.", (Object[])new Object[0]), TITLE, 2);
            return;
        }
        ArrayList<Object> commands = new ArrayList<Object>();
        List<Command> tagResolutionCommands = this.getTagConflictResolutionCommands((OsmPrimitive)geometry, (OsmPrimitive)way);
        if (tagResolutionCommands == null) {
            return;
        }
        commands.addAll(tagResolutionCommands);
        Collection<Node> nodePool = this.getUnimportantNodes(way);
        HashSet<Node> geometryPool = new HashSet<Node>();
        for (Node node : geometry.getNodes()) {
            List referrers = node.getReferrers();
            if (!node.isNew() || node.isDeleted() || referrers.size() != 1 || !((OsmPrimitive)referrers.get(0)).equals((Object)geometry) || way.containsNode(node) || this.hasInterestingKey((OsmPrimitive)node)) continue;
            geometryPool.add(node);
        }
        HashMap<Node, Node> nodeAssoc = new HashMap<Node, Node>();
        for (Node n3 : geometryPool) {
            Node nearest = this.findNearestNode(n3, nodePool);
            if (nearest == null) continue;
            nodeAssoc.put(n3, nearest);
            nodePool.remove(nearest);
        }
        for (Node n3 : geometryPool) {
            if (!nodeAssoc.containsKey(n3)) continue;
            nodePool.add(n3);
        }
        List geometryNodes = geometry.getNodes();
        for (int i = 0; i < geometryNodes.size(); ++i) {
            if (!nodeAssoc.containsKey(geometryNodes.get(i))) continue;
            geometryNodes.set(i, nodeAssoc.get(geometryNodes.get(i)));
        }
        commands.add(new ChangeNodesCommand(way, geometryNodes));
        for (Node node : nodeAssoc.keySet()) {
            commands.add(new MoveCommand((Node)nodeAssoc.get(node), node.getCoor()));
        }
        ReplaceGeometryAction.getCurrentDataSet().clearSelection(new PrimitiveId[]{geometry});
        commands.add(new DeleteCommand((OsmPrimitive)geometry));
        if (!nodePool.isEmpty()) {
            commands.add(new DeleteCommand(nodePool));
        }
        Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Replace geometry for way {0}", (Object[])new Object[]{way.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())}), commands));
    }

    protected Collection<Node> getUnimportantNodes(Way way) {
        HashSet<Node> nodePool = new HashSet<Node>();
        for (Node n : way.getNodes()) {
            List referrers = n.getReferrers();
            if (n.isDeleted() || referrers.size() != 1 || !((OsmPrimitive)referrers.get(0)).equals((Object)way) || this.hasInterestingKey((OsmPrimitive)n)) continue;
            nodePool.add(n);
        }
        return nodePool;
    }

    protected boolean hasImportantNode(Way geometry, Way way) {
        for (Node n : way.getNodes()) {
            if (geometry.containsNode(n)) continue;
            for (OsmPrimitive o : n.getReferrers()) {
                if (!(o instanceof Relation)) continue;
                return true;
            }
            if (!this.hasInterestingKey((OsmPrimitive)n)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasInterestingKey(OsmPrimitive object) {
        for (String key : object.getKeys().keySet()) {
            if (OsmPrimitive.isUninterestingKey((String)key)) continue;
            return true;
        }
        return false;
    }

    protected static boolean isInArea(Node node, Area area) {
        return node.isNewOrUndeleted() || area == null || area.contains((Point2D)node.getCoor());
    }

    protected static boolean isInArea(Way way, Area area) {
        if (area == null) {
            return true;
        }
        for (Node n : way.getNodes()) {
            if (ReplaceGeometryAction.isInArea(n, area)) continue;
            return false;
        }
        return true;
    }

    public List<Command> getTagConflictResolutionCommands(OsmPrimitive source, OsmPrimitive target) {
        List<OsmPrimitive> primitives = Arrays.asList(source, target);
        Set relationToNodeReferences = RelationToChildReference.getRelationToChildReferences(primitives);
        TagCollection tags = TagCollection.unionOfAllPrimitives(primitives);
        TagConflictResolutionUtil.combineTigerTags((TagCollection)tags);
        TagConflictResolutionUtil.normalizeTagCollectionBeforeEditing((TagCollection)tags, primitives);
        TagCollection tagsToEdit = new TagCollection(tags);
        TagConflictResolutionUtil.completeTagCollectionForEditing((TagCollection)tagsToEdit);
        CombinePrimitiveResolverDialog dialog = CombinePrimitiveResolverDialog.getInstance();
        dialog.getTagConflictResolverModel().populate(tagsToEdit, tags.getKeysWithMultipleValues());
        dialog.getRelationMemberConflictResolverModel().populate((Collection)relationToNodeReferences);
        dialog.setTargetPrimitive(target);
        dialog.prepareDefaultDecisions();
        if (!tags.isApplicableToPrimitive() || relationToNodeReferences.size() > 1) {
            dialog.setVisible(true);
            if (dialog.isCanceled()) {
                return null;
            }
        }
        return dialog.buildResolutionCommands();
    }

    private Node findNearestNode(Node node, Collection<Node> nodes) {
        if (nodes.contains(node)) {
            return node;
        }
        Node nearest = null;
        double distance = Double.parseDouble(Main.pref.get("utilsplugin2.replace-geometry.max-distance", "1"));
        LatLon coor = node.getCoor();
        for (Node n : nodes) {
            double d = n.getCoor().distance((Point2D)coor);
            if (!(d < distance)) continue;
            distance = d;
            nearest = n;
        }
        return nearest;
    }

    protected void updateEnabledState() {
        if (ReplaceGeometryAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(ReplaceGeometryAction.getCurrentDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && selection.size() >= 2);
    }
}

