/*
 * Decompiled with CFR 0.152.
 */
package utilsplugin2.selection;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UndoSelectionAction
extends JosmAction {
    private int myAutomaticSelectionHash;
    private Collection<OsmPrimitive> lastSel;
    private int index;

    public UndoSelectionAction() {
        super(I18n.tr((String)"Undo selection", (Object[])new Object[0]), "undoselection", I18n.tr((String)"Reselect last added object or selection form history", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:undoselection", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{"Undo selection"}), (int)90, (int)102), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/UndoSelection"));
    }

    public void actionPerformed(ActionEvent e) {
        LinkedList history = UndoSelectionAction.getCurrentDataSet().getSelectionHistory();
        int num = history.size();
        if (history == null || num == 0) {
            return;
        }
        Collection selection = UndoSelectionAction.getCurrentDataSet().getSelected();
        if (selection != null && selection.hashCode() != this.myAutomaticSelectionHash) {
            this.index = history.indexOf(this.lastSel);
        }
        int k = 0;
        HashSet newsel = new HashSet();
        do {
            this.index = this.index + 1 < history.size() ? ++this.index : 0;
            Collection histsel = (Collection)history.get(this.index);
            newsel.clear();
            newsel.addAll(histsel);
            newsel.retainAll(UndoSelectionAction.getCurrentDataSet().allNonDeletedPrimitives());
        } while (newsel.size() <= 0 && ++k < num);
        UndoSelectionAction.getCurrentDataSet().setSelected(newsel);
        this.lastSel = UndoSelectionAction.getCurrentDataSet().getSelected();
        this.myAutomaticSelectionHash = this.lastSel.hashCode();
    }

    protected void updateEnabledState() {
        if (UndoSelectionAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(UndoSelectionAction.getCurrentDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(true);
    }
}

