/*
 * Decompiled with CFR 0.152.
 */
package utilsplugin2.selection;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import utilsplugin2.selection.NodeWayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectAllInsideAction
extends JosmAction {
    public SelectAllInsideAction() {
        super(I18n.tr((String)"All inside [testing]", (Object[])new Object[0]), "selinside", I18n.tr((String)"Select all inside selected polygons", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:selinside", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{"All inside"}), (int)73, (int)107), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/SelectAllInside"));
    }

    public void actionPerformed(ActionEvent e) {
        long t = System.currentTimeMillis();
        LinkedHashSet selectedWays = OsmPrimitive.getFilteredSet((Collection)SelectAllInsideAction.getCurrentDataSet().getSelected(), Way.class);
        LinkedHashSet selectedRels = OsmPrimitive.getFilteredSet((Collection)SelectAllInsideAction.getCurrentDataSet().getSelected(), Relation.class);
        for (Relation r : selectedRels) {
            if (r.isMultipolygon()) continue;
            selectedRels.remove(r);
        }
        HashSet<Way> newWays = new HashSet<Way>();
        HashSet<Node> newNodes = new HashSet<Node>();
        if (!selectedWays.isEmpty()) {
            for (Way w : selectedWays) {
                NodeWayUtils.addAllInsideWay(SelectAllInsideAction.getCurrentDataSet(), w, newWays, newNodes);
            }
        }
        if (!selectedRels.isEmpty()) {
            for (Relation r : selectedRels) {
                NodeWayUtils.addAllInsideMultipolygon(SelectAllInsideAction.getCurrentDataSet(), r, newWays, newNodes);
            }
        }
        if (!newWays.isEmpty() || !newNodes.isEmpty()) {
            SelectAllInsideAction.getCurrentDataSet().addSelected(newWays);
            SelectAllInsideAction.getCurrentDataSet().addSelected(newNodes);
        } else {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Nothing found. Please select some closed ways or multipolygons to find all primitives inside them!", (Object[])new Object[0]), I18n.tr((String)"Warning", (Object[])new Object[0]), 2);
        }
    }

    protected void updateEnabledState() {
        if (SelectAllInsideAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(SelectAllInsideAction.getCurrentDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        if (selection == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(!selection.isEmpty());
    }
}

