/*
 * Decompiled with CFR 0.152.
 */
package utilsplugin2.selection;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import utilsplugin2.selection.NodeWayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectedWaysAction
extends JosmAction {
    public ConnectedWaysAction() {
        super(I18n.tr((String)"All connected ways", (Object[])new Object[0]), "adjwaysall", I18n.tr((String)"Select all connected ways", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:adjwaysall", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{"All connected ways"}), (int)69, (int)102), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/SelectConnectedWays"));
    }

    public void actionPerformed(ActionEvent e) {
        Collection selection = ConnectedWaysAction.getCurrentDataSet().getSelected();
        LinkedHashSet selectedNodes = OsmPrimitive.getFilteredSet((Collection)selection, Node.class);
        LinkedHashSet selectedWays = OsmPrimitive.getFilteredSet((Collection)ConnectedWaysAction.getCurrentDataSet().getSelected(), Way.class);
        HashSet<Way> newWays = new HashSet<Way>();
        if (!selectedNodes.isEmpty()) {
            NodeWayUtils.addWaysConnectedToNodes(selectedNodes, newWays);
        }
        newWays.addAll(selectedWays);
        NodeWayUtils.addWaysConnectedToWaysRecursively(selectedWays, newWays);
        ConnectedWaysAction.getCurrentDataSet().setSelected(newWays);
    }

    protected void updateEnabledState() {
        if (ConnectedWaysAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(ConnectedWaysAction.getCurrentDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        if (selection == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(!selection.isEmpty());
    }
}

